/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */
/* $Header: /Source/Media/bryant/DisplayTool/RCS/globals.c,v 1.2 92/10/29 17:55:14 drapeau Exp $ */
/* $Log:	globals.c,v $
 * Revision 1.2  92/10/29  17:55:14  drapeau
 * Minor adjustments to functions responsible for creating and painting the
 * popup canvases used when displaying an image full-size.  The problem occurred
 * when a slide contained multiple images to be drawn: the result was that the
 * same image would be drawn in each of the full-sized canvases, instead of each
 * separate image being drawn in the separate canvases.
 * 
 * Revision 1.1  92/10/29  13:57:23  drapeau
 * Initial revision
 *  */
static char dtGlobals[] = "$Header: /Source/Media/bryant/DisplayTool/RCS/globals.c,v 1.2 92/10/29 17:55:14 drapeau Exp $";

#include "DisplayTool.h"


struct itimerval timer;

Xv_singlecolor colors[] = {
  { 255,   0,   0 },  /* red */
  {   0, 255,   0 },  /* green */
  {   0,   0, 255 },  /* blue */
};  

Cms cms;
int cmsSize = 3;
unsigned long *pixelValues;

/*
 * Instance XV_KEY_DATA key.  An instance is a set of related
 * user interface objects.  A pointer to an object's instance
 * is stored under this key in every object.  This must be a
 * global variable.
 */
Attr_attribute	INSTANCE;
DisplayTool_baseWindow_objects        *baseWindow;
DisplayTool_infoPopup_objects	      *infoPopup;
DisplayTool_resizePopup_objects	      *resizePopup;
DisplayTool_helpPopup_objects         *helpPopup;
DisplayTool_slidePopup_objects        *slidePopup;
DisplayTool_slideNumberPopup_objects  *slideNumberPopup;

char    *canonFilename;

/*
 *  global variables
 */
char      *input_file;
FILE      *fp;
Scrollbar galleryScrollbar;
Scrollbar slidesScrollbar;
Window    galleryWin;
Window    slidesWin;
Display   *display;
Colormap  galleryCmap;
Colormap  slidesCmap;
IconData  iconData;
Frame     globalPopup[MaxNumImages];
Canvas    globalCanvas[MaxNumImages];
Frame     oldPopups[MaxNumImages];
Canvas    oldCanvases[MaxNumImages];
XGCValues gcvalues;
IMAGE     dtImage	[MaxNumImages];
IMAGE     gallery	[MaxNumImages];
IMAGE     clipboardImage[MaxNumImages];
SCR       slide		[MaxNumSlides];

int numGalleryImages     = 0;
int numSlidesImages      = 0;
int numClipboardImages   = 0;
int selectedGalleryImage = None;
int selectedSlideImage   = None;
int selectedSlide        = 0;
int oldSelectedSlide     = 0;
int previousSlide        = 0;
int largeFactor          = 6;
int slideSize            = Small;
int beginDoubleBuffer    = 1;      /* reset this to 1 whenever you get the OpenDoc message */
int changes              = False;
int popupTot             = 0;
int oldPopupTot          = 0;
int dontCheckGeometry    = 0;
int performing           = 0;
int pauseMode            = 0;
int timeCount            = 0;
int borderOffset;
int imagesPerRow;
int numSlides;
int			printDiags	= 0;
int			cmap[NumColors];
Xv_font 		listFont; 
char			currentFilename[MAXPATHLEN];
char			dummy[MAXPATHLEN];
char			diagString[MAXPATHLEN];
Attr_attribute		canvasKeyData;


Sender* sender;
Receiver* receiver;
Port senderPort;
int ReceiverPortNumber;
