/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_buf.c                                                     |
|                                                                              |
|    Contents : Functions to write an editlist to a character buffer           |
|               in the format of an MaMA_EDIT_LIST_FILE.                       |
|               The character buffer is neede for drag & drop facilities.      |
|                                                                              |
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>

char *EditListBuf;
char *Buf;
extern EDITLISTINFO *EditListInfo;

/******************************************************************************\
*                                                                              *
*        Name : WriteEditList2Buf                                              *
*                                                                              *
* Description : Return a char ptr to a string containing the EditList in chars *
*                                                                              *
\******************************************************************************/

char *
WriteEditList2Buf(EDITLIST *EditListPtr)
{
    char EditListFilename[MAXPATHLEN];
    
    EditListBuf = (char *) malloc((unsigned)((3000) * sizeof(char)));
    Buf = (char *) malloc((unsigned)((300) * sizeof(char)));

    strcpy(EditListFilename, EditListInfo->FullFileName);

    strcpy(EditListBuf, "#MaMA_EDIT_LIST_FILE-");
    strcat(EditListBuf, MaMA_VERSION);

    strcat(EditListBuf, "\n#BEGIN_EDITLIST\n");

    while (EditListPtr != NIL(EDITLIST *))
    {
        WriteEdit2Buf(EditListPtr);
        EditListPtr = EditListPtr->next;
    }
    strcat(EditListBuf, "#END_EDITLIST\n");
    return(EditListBuf);
}

/******************************************************************************\
*                                                                              *
*        Name : WriteEdit2Buf                                                  *
*                                                                              *
* Description : Writes the info of an Edit to the buffer                       *
*                                                                              *
\******************************************************************************/

void
WriteEdit2Buf(EDITLIST *EditListPtr)
{
    ACTIONLIST *ActionListPtr;

    strcat(EditListBuf, "#BEGIN_EDIT\n");

    sprintf(Buf, "#%s\n", EditListPtr->Label);
    strcat(EditListBuf, Buf);

    sprintf(Buf, "#%d\n", EditListPtr->TotalDur);
    strcat(EditListBuf, Buf);

    ActionListPtr = EditListPtr->ActionList;

    while(ActionListPtr != NIL(ACTIONLIST *))
    {
        WriteActionList2Buf(ActionListPtr);
        ActionListPtr = ActionListPtr->next;
    }

    strcat(EditListBuf, "#END_EDIT\n");
}

/******************************************************************************\
*                                                                              *
*        Name : WriteActionList2Buf                                            *
*                                                                              *
* Description : Writes the action list to the buffer                           *
*                                                                              *
\******************************************************************************/

void
WriteActionList2Buf(ACTIONLIST *ActionListPtr)
{
    strcat(EditListBuf, "#BEGIN_ACTION\n");

    sprintf(Buf, "#%s\n", ActionListPtr->Path->Dir);
    strcat(EditListBuf, Buf);

    sprintf(Buf, "#%s\n", ActionListPtr->Path->File);
    strcat(EditListBuf, Buf);

    sprintf(Buf, "#%d\n", ActionListPtr->Duration);
    strcat(EditListBuf, Buf);

    sprintf(Buf, "#%d\n", ActionListPtr->Action->ActionType);
    strcat(EditListBuf, Buf);

    switch(ActionListPtr->Action->ActionType)
    {
        case Jump:
            sprintf(Buf, "#%s\n", ActionListPtr->Action->Param->Hyperlink);
            strcat(EditListBuf, Buf);
            break;

        case GotoFP:
            break;
        case GotoNP:
            sprintf(Buf, "#%d\n", ActionListPtr->Action->Param->Times);
            strcat(EditListBuf, Buf);
            break;

        case GotoPP:
            sprintf(Buf, "#%d\n", ActionListPtr->Action->Param->Times);
            strcat(EditListBuf, Buf);
            break;

        case GotoLP:
            break;
        case ZoomIn:
            sprintf(Buf, "#%d\n", ActionListPtr->Action->Param->Fit);
            strcat(EditListBuf, Buf); 
            break;

        case ZoomOut:
            sprintf(Buf, "#%d\n", ActionListPtr->Action->Param->Fit);
            strcat(EditListBuf, Buf);
            break;

        case Zoom100:
            sprintf(Buf, "#%d\n", ActionListPtr->Action->Param->Fit);
            strcat(EditListBuf, Buf);
            break;

        case OpenDoc:
            break;

        case CloseDoc:
            break;

        case QuitDoc:
            break;

        case InitDoc:
            break;
    }
    strcat(EditListBuf, "#END_ACTION\n");
}
