/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_filelist.c                                                |
|                                                                              |
|    Contents :                                                                |
|                                                                              |
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>

extern FILELIST *FileList;
extern FILELIST *CurDoc;
extern int NumberOfDoc;
extern Xv_font    *listFont;

/******************************************************************************\
*                                                                              *
*        Name : PrintFileList                                                  *
*                                                                              *
* Description : Prints the contents of the file list                           *
*                                                                              *
\******************************************************************************/

void
PrintFileList(FILELIST *FileListPtr)
{
    Print("--F--I--L--E--L--I--S--T--\n\n");
    while(FileListPtr != NIL(FILELIST *))
    {
        sprintf(Debug_Msg, "\tdir      : %s\n", FileListPtr->File->Path);
        Print(Debug_Msg);
        sprintf(Debug_Msg, "\tfile     : %s\n", FileListPtr->File->Name);
        Print(Debug_Msg);
        sprintf(Debug_Msg, "\tselected : %d\n\n", FileListPtr->Selected);
        Print(Debug_Msg);
        FileListPtr = FileListPtr->next;
    }
    Print("--------------------------\n");
}

/******************************************************************************\
*                                                                              *
*        Name : DeleteSelectedFile                                             *
*                                                                              *
* Description : Delete the first selected from the FileList                    *
*                                                                              *
\******************************************************************************/

FILELIST 
*DeleteSelectedFile(FILELIST *FileListPtr)
{
    FILELIST *Tmp;
    FILELIST *ReturnPtr;

    ReturnPtr = FileListPtr;
    if (FileListPtr != NIL(FILELIST *)) 
    { 
        if (FileListPtr->Selected)
        {
            Tmp = FileListPtr;
            ReturnPtr = FileListPtr->next; 
            FreeLinkList(Tmp->File->LinkList);
            free(Tmp->File);
            free(Tmp);
        } else {
            Tmp = FileListPtr->next;
            while (Tmp != NIL(FILELIST *))
            {    
                if (Tmp->Selected)
                {
                    FileListPtr->next = Tmp->next;
                    FreeLinkList(Tmp->File->LinkList);
                    free(Tmp->File);
                    free(Tmp);
                    break;
                } else {
                    FileListPtr = FileListPtr->next;
                    Tmp = Tmp->next;
                } 
            }
        }
    } 
    return(ReturnPtr);
}

/******************************************************************************\
*                                                                              *
*        Name : UnselectFile                                                   *
*                                                                              *
* Description : Set the field Selected of FileList to "Value"                  *
*                                                                              *
\******************************************************************************/

void
UnselectFile(FILELIST *FileListPtr)
{
    while(FileListPtr != NIL(FILELIST *))
    {
        FileListPtr->Selected = False;
        FileListPtr = FileListPtr->next;
    }
}

/******************************************************************************\
*                                                                              *
*        Name : SelectFile                                                     *
*                                                                              *
* Description : Set the field Selected of FileList to "Value"                  *
*               Deselect all other entries                                     *
*                                                                              *
\******************************************************************************/

void
SelectFile( FILELIST *FileListPtr, int row)
{
    int i;

    i = 0;
    CurDoc = NIL(FILELIST *);

    while (FileListPtr != NIL(FILELIST *))
    {
        FileListPtr->Selected = False;

        if (i++ == row)
        {
            FileListPtr->Selected = True;
            CurDoc = FileListPtr;
        }
        FileListPtr = FileListPtr->next;
    }
}

/******************************************************************************\
*                                                                              *
*        Name : InsertFile                                                     *
*                                                                              *
* Description : Inserts a new entry in fornt of FileList                       *
*                                                                              *
\******************************************************************************/

FILELIST 
*InsertFile(FILELIST *FileListPtr, char *dir_name, char *file_name)
{
    FILELIST *First;

    First = (FILELIST *)malloc((unsigned )sizeof(FILELIST));
    First->File = (DOCINFO *)malloc((unsigned )sizeof(DOCINFO));
    First->File->LinkList = NIL(LINKLIST *);

    /*
     * Fill fields
     */
    strcpy(First->File->Path, dir_name);
    strcpy(First->File->Name, file_name);
    First->Selected = True;

    /*
     * Place new entry in front of list
     */
    First->next = FileListPtr;
    FileListPtr = First;

    CurDoc = First;

    return(FileListPtr);
}
 
/******************************************************************************\
*                                                                              *
*        Name : DisplayFileInfo                                                *
*                                                                              *
* Description : Places the dir- and file name as the current target document   *
*                                                                              *
\******************************************************************************/

void
DisplayFileInfo(FILELIST *FileListPtr, int row, int Selected)
{
    FILELIST *Tmp;
    int             i;

    for(i = 0; ((i < row) && (FileListPtr != NIL(FILELIST *))) ; i++)
    {
        FileListPtr = FileListPtr->next;
    }
 
    if (FileListPtr != NIL(FILELIST *))
    {
        switch(Selected)
        {
            case True:
                xv_set(MaMA_Edit_Panel->Dir_tf, 
                    PANEL_VALUE, FileListPtr->File->Path, 
                    NULL);
                xv_set(MaMA_Edit_Panel->File_tf, 
                    PANEL_VALUE, FileListPtr->File->Name, 
                    NULL);

                break;
        }
    }
}
 
/******************************************************************************\
*                                                                              *
*        Name : BuildFileList                                                  *
*                                                                              *
* Description : Returns a ptr to a file list build from the documents          *
*               of an actionlist                                               *
*                                                                              *
\******************************************************************************/

FILELIST
*BuildFileList(ACTIONLIST *ActionListPtr)
{
    FILELIST *FileListPtr;
    FILELIST *ReturnPtr;

    FileListPtr = NIL(FILELIST *);
    ReturnPtr = FileListPtr;

    while(ActionListPtr != NIL(ACTIONLIST *))
    {
        FileListPtr = ReturnPtr;
	if (!FileInList(FileListPtr, ActionListPtr->Path->File,
		ActionListPtr->Path->Dir))	
        {
            /*
             * Document did not exist
             */
	    FileListPtr = (FILELIST *)malloc((unsigned )sizeof(FILELIST));
	    FileListPtr->File = (DOCINFO *)malloc((unsigned )sizeof(DOCINFO));
            FileListPtr->File->LinkList = NIL(LINKLIST *);
    
            strcpy(FileListPtr->File->Path, ActionListPtr->Path->Dir);
            strcpy(FileListPtr->File->Name, ActionListPtr->Path->File);
            FileListPtr->Selected = False;
            FileListPtr->next = NIL(FILELIST *);

            /*
             * Place file in front of filelist
             */
            FileListPtr->next = ReturnPtr;
            ReturnPtr = FileListPtr;
        }   
        ActionListPtr = ActionListPtr->next;
    }

    return(ReturnPtr);
}

/******************************************************************************\
*                                                                              *
*        Name : FileinList                                                     *
*                                                                              *
* Description : Checks if Frame document is already in the list of target docs *
*                                                                              *
\******************************************************************************/

int
FileInList(FILELIST *FileListPtr, char *File, char *Dir)
{
    int FILE_EXIST;
    int row;
    FILE_EXIST = False;

    /*
     * Check if document is already in filelist
     */
    row = 0;

    while((FileListPtr != NIL(FILELIST *)) && (! FILE_EXIST))
    {
        if (strcmp(FileListPtr->File->Name, File) == 0)
        {
            if (strcmp(FileListPtr->File->Path, Dir)
                == 0)
            {
                FILE_EXIST = True;          /* File already exist in filelist */

		/*
		 * Select the existing doc for the users,
		 * so they can see it with their own eyes!
		 */
		SelectFile(FileList, row);

		xv_set(MaMA_Edit_Panel->Doc_List,
                       PANEL_LIST_SELECT, row, TRUE, NULL);
		xv_set(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE, Dir, NULL);
		xv_set(MaMA_Edit_Panel->File_tf, PANEL_VALUE, File, NULL);
            }
        }
        FileListPtr = FileListPtr->next;
	row++;
    }
    return(FILE_EXIST);
}

/******************************************************************************\
*                                                                              *
*        Name : FindSelectedDoc                                                *
*                                                                              *
* Description : Returns the currently selected document                        *
*                                                                              *
\******************************************************************************/

FILELIST
*FindSelectedDoc(FILELIST *FileListPtr)
{
    while(FileListPtr != NIL(FILELIST *))
    {
        if (FileListPtr->Selected) return(FileListPtr);

        FileListPtr = FileListPtr->next;
    }

    return(NIL(FILELIST *));
}

/******************************************************************************\
*                                                                              *
*        Name : FreeFileList                                                   *
*                                                                              *
* Description : Frees the allocated space for the FileList                     *
*                                                                              *
\******************************************************************************/

void
FreeFileList(FILELIST *FileListPtr)
{
    if (FileListPtr == NIL(FILELIST*))
        return;

    if (FileListPtr->next == NIL(FILELIST*))
    {
        FreeLinkList(FileListPtr->File->LinkList);
        free(FileListPtr->File);
        free(FileListPtr);
        return;
    }

    FreeFileList(FileListPtr->next);

    FreeLinkList(FileListPtr->File->LinkList);
    free(FileListPtr->File);
    free(FileListPtr);
}

/******************************************************************************\
*                                                                              *
*        Name : FreeLinkList                                                   *
*                                                                              *
* Description : Frees the allocated space for the LinkList                     *
*                                                                              *
\******************************************************************************/

void
FreeLinkList(LINKLIST *LinkListPtr)
{
    if (LinkListPtr == NIL(LINKLIST*))
        return;

    if (LinkListPtr->next == NIL(LINKLIST*))
    {
        free(LinkListPtr);
        return;
    }

    FreeLinkList(LinkListPtr->next);
    free(LinkListPtr);
}

/******************************************************************************\
*                                                                              *
*        Name : AddFileInList                                                  *
*                                                                              *
* Description : Add the selected/dropped FM doc. in the Target Documents List  *
*                                                                              *
\******************************************************************************/
void
AddFileInList(char *dir, char *file)
{
        /*
         * Check if document is not already in the list of target docs
         */
        if(FileInList(FileList, file, dir))
        {
            xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_RIGHT_FOOTER,
                dgettext("MaMA_labels", 
                    "Document already in list! action ignored."), NULL);
 
            PutLinksInChoice(CurDoc->File->LinkList);
 
            return;
        }
 
        xv_set(MaMA_Edit_Panel->Dir_tf, PANEL_VALUE, dir, NULL);
        xv_set(MaMA_Edit_Panel->File_tf, PANEL_VALUE, file, NULL);
        xv_set(MaMA_Edit_Panel->Doc_List,
            PANEL_LIST_INSERT,0,
            PANEL_LIST_STRING,0, file,
            PANEL_LIST_FONT, 0, listFont,
            NULL);
 
        /*
         * Place the complete path + filename in the Filelist
         */
        FileList = InsertFile(FileList, dir, file);
     
        /*
         * Display info of last entered document
         */
        (void )DisplayFileInfo(FileList, 0, True);
     
        /*
         * Fill Hyperlink list with names if already fetched from FMdoc
         */
        PutLinksInChoice(CurDoc->File->LinkList);
 
        /*
         * Mark first entry as selected
         */
        xv_set(MaMA_Edit_Panel->Doc_List, PANEL_LIST_SELECT, 0, TRUE, NULL);
 
        NumberOfDoc++;
	 
        /*
         * (De-) activate Document buttons
         */
        DocButtonsActive();
        
        xv_set(MaMA_Edit_Panel->doc_drop_target, PANEL_DROP_FULL, TRUE, NULL);

	(void )PrintFileList(FileList);
}
