/******************************************************************************\
*                                                                              *
* The software for `MaMA' was developed by:    H. K. Blokhuis and              *
*                                              S. L. Voogd                     *
*                                                                              *
* as part of their graduation for:     the Hoger Informatica Onderwijs (HIO)   *
* in Enschede.                             ---------------------------------   *
* The project was carried out at:          Sun Microsystems Nederland B.V.     *
* in Amersfoort.                           -------------------------------     *
*                                                                              *
*                                                                              *
* Copyright (c) 1992 Sun Microsystems Nederland B.V.                           *
*                                                                              *
* Permission to use, copy, modify, and distribute this software and            *
* its documentation for any purpose is hereby granted without fee, provided    *
* that (i) the above copyright notices and this permission notice appear in    *
* all copies of the software and related documentation, and (ii) the name      *
* Sun may not be used in any advertising or publicity relating to              *
* the software without the specific, prior written permission of               *
* Sun.                                                                         *
*                                                                              *
* THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND,           *
* EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY             *
* WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.             *
*                                                                              *
* IN NO EVENT SHALL SUN BE LIABLE FOR ANY SPECIAL, INCIDENTAL,                 *
* INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES                *
* WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT       *
* ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,        *
* ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS          *
* SOFTWARE.                                                                    *
*                                                                              *
\******************************************************************************/

/*----------------------------------------------------------------------------*\
|                                                                              |
|        File : MaMA_read.c                                                    |
|                                                                              |
|    Contents : Functions to read in a MaMA editlist file                      |
|                                                                              |
\*----------------------------------------------------------------------------*/

#include <MaMA_include.h>
#include <MaMA_global.h>
 
extern EDITLISTINFO *EditListInfo;
static char buf1[300];
static char buf2[100];

/******************************************************************************\
*                                                                              *
*        Name : ReadEditListFromFile                                           *
*                                                                              *
* Description : Reads an EditList from the given file                          *
*                                                                              *
\******************************************************************************/

EDITLISTINFO
*ReadEditListFromFile(char *FileName)
{
    char Header[100];
    FILE *EditListFile;
    
    xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, TRUE, NULL);
    xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, TRUE, NULL);

    /*
     * open MaMA edits file
     */
    if((EditListFile = fopen(FileName, "r")) == NULL)
    {
        notice_prompt (MaMA_Main_Window->Main_Window, NULL,
            NOTICE_MESSAGE_STRINGS,
            dgettext("MaMA_labels", "Unable to open the file!"),
            NULL,
            NOTICE_BUTTON, "OK", 100,
            NULL);
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return(NIL(EDITLISTINFO *));
    }

    /*
     * read MaMA edits file header
     */
    sprintf(Header, "MaMA_EDIT_LIST_FILE-%s", MaMA_VERSION);
    if (Check4WrongFormat(EditListFile, "#%s\n", Header, 1))
    {
        WrongFormatMsg();
        fclose(EditListFile);
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return(NIL(EDITLISTINFO *));
    }

    if (Check4WrongFormat(EditListFile, "#%s\n", "BEGIN_EDITLIST", 1))
    {
        WrongFormatMsg();
        fclose(EditListFile);
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return(NIL(EDITLISTINFO *));
    }

    /*
     * read edits
     */
    EditListInfo->EditList = ReadEditFromFile(EditListFile);

    if (EditListInfo->EditList == NIL(EDITLIST *))
    {
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return(NIL(EDITLISTINFO *));
    } else {
        xv_set(MaMA_Edit_Panel->Edit_Panel, FRAME_BUSY, FALSE, NULL);
        xv_set(MaMA_Main_Window->Main_Window, FRAME_BUSY, FALSE, NULL);
        return(EditListInfo);
    }
}

/******************************************************************************\
*                                                                              *
*        Name : ReadEditFromFile                                               *
*                                                                              *
* Description : Read Edit information                                          *
*                                                                              *
\******************************************************************************/

EDITLIST
*ReadEditFromFile(FILE *EditListFile)
{
    EDITLIST *EditList;
    EDITLIST *EditListPtr;
    EDITLIST *ReturnPtr;
    int *return_error;

    ReturnPtr = NIL(EDITLIST *);

    while ( !(Check4WrongFormat(EditListFile, "#%s\n", "BEGIN_EDIT", 1)))
    {
        EditListPtr = (EDITLIST *)malloc((unsigned)sizeof(EDITLIST));
        EditListPtr->next = NIL(EDITLIST *);

        /*
         * read label and total dur of an edit
         */
        if (fscanf(EditListFile, "#%s\n#%d\n", buf1, 
            &EditListPtr->TotalDur) != 2)
        {
            WrongFormatMsg();
            return(NIL(EDITLIST *));
        }

        strcpy(EditListPtr->Label, buf1);

        EditListPtr->Selected = False;

        /*
         * read action list info
         */
        EditListPtr->ActionList = ReadActionListFromFile(EditListFile, 
            return_error);

        /*
         * if error occurred return NIL
         */
        if (!(*return_error))
            return(NIL(EDITLIST *));

        /*
         * Place the read edit at end of list
         */
        if (ReturnPtr == NIL(EDITLIST *)) 
        { 
            ReturnPtr = EditListPtr; 
            EditList = EditListPtr; 
        } else { 
            EditList->next = EditListPtr; 
            EditList = EditList->next;
        }
    }

    fclose(EditListFile);

    return(ReturnPtr);
}

/******************************************************************************\
*                                                                              *
*        Name : ReadActionListFromFile                                         *
*                                                                              *
* Description : Read ActionList information                                    *
*                                                                              *
\******************************************************************************/

ACTIONLIST
*ReadActionListFromFile(FILE *EditListFile, int *return_val)
{
    ACTIONLIST *ActionList;
    ACTIONLIST *ActionListPtr;
    ACTIONLIST *ReturnPtr;

    ReturnPtr = NIL(ACTIONLIST *);
    *return_val = True;

    while ( !(Check4WrongFormat(EditListFile, "#%s\n", "BEGIN_ACTION", 1)))
    {
        ActionListPtr = (ACTIONLIST *)malloc((unsigned)sizeof(ACTIONLIST));
        ActionListPtr->Action = (ACTION *)malloc((unsigned)sizeof(ACTION));
        ActionListPtr->Action->Param = (PARAM *)malloc((unsigned)sizeof(PARAM));
        ActionListPtr->Action->Param->WindowPos =
            (POSITION *)malloc((unsigned )sizeof(POSITION));

        /*
         * read Dir, File, duration and type of action
         */
        if(fscanf(EditListFile, "#%s\n#%s\n#%d\n#%d\n", buf1, buf2, 
            &ActionListPtr->Duration, &ActionListPtr->Action->ActionType) != 4) 
        {
            WrongFormatMsg();
            *return_val = False;
            return(NIL(ACTIONLIST *));
        }

        /*
         * Copy read strings into Dir and File fields
         */
        ActionListPtr->Path = (FILEINFO *)malloc((unsigned)sizeof(FILEINFO));

        strcpy(ActionListPtr->Path->Dir,buf1);
        strcpy(ActionListPtr->Path->File, buf2);

        ActionListPtr->next = NIL(ACTIONLIST *);
        ActionListPtr->Selected = False;

        /*
         * read parameters according to actiontype
         */
        switch(ActionListPtr->Action->ActionType)
        {
            case Jump:
                if (fscanf(EditListFile, "#%s\n", buf1) != 1)
                {
                    WrongFormatMsg();
                    *return_val = False;
                    return(NIL(ACTIONLIST *));
                }
                strcpy(ActionListPtr->Action->Param->Hyperlink, buf1);

                break;
            case GotoFP:
                break;
            case GotoNP:
                ActionListPtr->Action->Param = (PARAM *)malloc(
                    (unsigned)sizeof(PARAM));
                if (fscanf(EditListFile, "#%d\n", 
                    &ActionListPtr->Action->Param->Times) != 1)
                {
                    WrongFormatMsg();
                    *return_val = False;
                    return(NIL(ACTIONLIST *));
                }

                break;
            case GotoPP:
                ActionListPtr->Action->Param = (PARAM *)malloc(
                    (unsigned)sizeof(PARAM));
                if (fscanf(EditListFile, "#%d\n", 
                    &ActionListPtr->Action->Param->Times) != 1)
                {
                    WrongFormatMsg();
                    *return_val = False;
                    return(NIL(ACTIONLIST *));
                }

                break;
            case GotoLP:
                break;
            case ZoomIn:
                ActionListPtr->Action->Param = (PARAM *)malloc(
                    (unsigned)sizeof(PARAM));
                if (fscanf(EditListFile, "#%d\n", 
                    &ActionListPtr->Action->Param->Fit) != 1)
                {
                    WrongFormatMsg();
                    *return_val = False;
                    return(NIL(ACTIONLIST *));
                }

                break;
            case ZoomOut:
                ActionListPtr->Action->Param = (PARAM *)malloc(
                    (unsigned)sizeof(PARAM));
                if (fscanf(EditListFile, "#%d\n", 
                    &ActionListPtr->Action->Param->Fit) != 1)
                {
                    WrongFormatMsg();
                    *return_val = False;
                    return(NIL(ACTIONLIST *));
                }

                break;
            case Zoom100:
                ActionListPtr->Action->Param = (PARAM *)malloc(
                    (unsigned)sizeof(PARAM));
                if (fscanf(EditListFile, "#%d\n", 
                    &ActionListPtr->Action->Param->Fit) != 1)
                {
                    WrongFormatMsg();
                    *return_val = False;
                    return(NIL(ACTIONLIST *));
                }

                break;
            case OpenDoc:

                break;
            case CloseDoc:

                break;
            case QuitDoc:

                break;
            case InitDoc:

                break;
        }
        if (Check4WrongFormat(EditListFile, "#%s\n", "END_ACTION", 1))
        {
            WrongFormatMsg();
            *return_val = False;
            return(NIL(ACTIONLIST *));
        }

        /*
         * Place new action at end of list
         */
        if (ReturnPtr == NIL(ACTIONLIST *))
        {
            ReturnPtr = ActionListPtr;
            ActionList = ActionListPtr;
        } else {
            ActionList->next = ActionListPtr;
            ActionList = ActionList->next;
        }
    }

    return(ReturnPtr);
}

/******************************************************************************\
*                                                                              *
*        Name : WrongFormatMsg                                                 *
*                                                                              *
* Description : Notice when format error is encountered                        *
*                                                                              *
\******************************************************************************/

void
WrongFormatMsg()
{
    notice_prompt (MaMA_Main_Window->Main_Window, NULL,
        NOTICE_MESSAGE_STRINGS,
        dgettext("MaMA_labels", "Wrong format!"),
        dgettext("MaMA_labels", "Load canceled."),
        NULL,
        NOTICE_BUTTON, "OK", 100,
        NULL);
}

/******************************************************************************\
*                                                                              *
*        Name : Check4WrongFormat                                              *
*                                                                              *
* Description : To check if an format error is encountered                     *
*                                                                              *
\******************************************************************************/

int
Check4WrongFormat(FILE *File, char *Format, char *Text, int CONVs)
{
    char buffer[400];

    if ((fscanf(File, Format, buffer) == CONVs) && (strcmp(Text,buffer) == 0))
    {
        *buffer = '\0';
        return(False);
    } else {
        *buffer = '\0';

        return(True);
    }
}
