/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/drapeau/PortManager/RCS/PortList.h,v 1.3 91/09/18 13:06:29 drapeau Exp Locker: drapeau $ */
/* $Log:	PortList.h,v $
 * Revision 1.3  91/09/18  13:06:29  drapeau
 * Changed the name of the major include file from LinkProtocol.h to MAEstro.h, in keeping with the
 * project name.
 * 
 * Revision 1.2  91/06/17  18:14:34  drapeau
 * Added copyright notice.
 * 
 * Revision 1.1  90/11/30  13:44:48  drapeau
 * Initial revision
 *  */

#ifndef _PortList_
#define _PortList_

static char portListHeaderRcsid[] ="$Header: /Source/Media/drapeau/PortManager/RCS/PortList.h,v 1.3 91/09/18 13:06:29 drapeau Exp Locker: drapeau $";

#include <stdio.h>
#include <MAEstro.h>

typedef struct _PortList
{
  Port*			port;
  struct _PortList*	next;
} PortList;

PortList*	NewPortList();
void		DestroyPortList(PortList* portList);
void 		PortListAddPortToList(PortList** portListPtr, Port* newPort);
void 		PortListPrint(PortList* portList);
void		PortListRemovePortFromList(PortList** portListPtr, Port* portToRemove);

#endif
