/*
 * Copyright (c) 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoObject/RCS/CVD1000Driver.h,v 1.23 92/09/04 14:34:08 drapeau Exp $ */
/* $Log:	CVD1000Driver.h,v $
 * Revision 1.23  92/09/04  14:34:08  drapeau
 * Added a few defined constants for functions "SearchIsInProgress()" and
 * EditIsInProgress(), used by the RecordFromTo() method.
 * Also, added function definitions for these new functions.
 * Also, changed function definitions for a few newly-renamed functions that
 * now reflect the correct naming scheme for the CVD1000 module.
 * 
 * Revision 1.22  92/09/01  16:56:48  drapeau
 * Cosmetic changes to function definitions to make the code easier to read.
 * 
 * Revision 1.21  92/08/25  16:27:24  drapeau
 * Made a couple of changes:
 * * Added function prototypes to function declarations for better ANSI
 *   compliance and ease of debugging.
 * * Added definitions for a few new functions used internally by the
 *   CVD1000 driver.
 * 
 * Revision 1.2  92/08/05  16:18:08  drapeau
 * Replaced octal valuas with equivalent hex values, to simplify
 * the task of reading the code.
 * 
 * Revision 1.1  92/06/17  01:01:03  drapeau
 * Changed termio usage, used more portable "termio" structure and
 * associated calls instead of "termios".
 * 
 * Revision 1.0  92/06/17  00:19:52  drapeau
 * Initial revision
 *  */

static char cvdHeaderRcsid[] = "$Header: /Source/Media/collab/VideoObject/RCS/CVD1000Driver.h,v 1.23 92/09/04 14:34:08 drapeau Exp $";

#include <errno.h>
#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/termio.h>
#include <sys/file.h>
#include "videoObj.h"
#include "PlayerStatus.h"

/* Packet header */
#define Header    '\x81'					    /* Header has destination address = 1, non-broadcast */
#define RcvHeader '\x90'

/* Message header */
#define Command1 '\x01'
#define Command2 '\x02'
#define Command3 '\x03'
#define Command4 '\x04'
#define Inq      '\x09'
#define Address  '\x30'

/* Message categories */
#define Interface '\x00'
#define Vcr       '\x02'
#define Effects   '\x03'

/* VCR modes */
#define CVDPower  '\x00'
#define Mode1     '\x01'
#define Mode2     '\x02'
#define Search    '\x03'
#define EditCtrl  '\x05'
#define Transport '\x0A'
#define SubCtrl   '\x10'
#define Media     '\x12'
#define OSD       '\x15'

/* Counter Types */
#define TimeCode    '\x21'
#define ChapterCode '\x31'
#define IndexCode   '\x32'

/* Packet terminator */
#define Terminator '\xFF'

/* Reply */
#define CVDAck      1
#define Completion  2
#define CVDError    3
#define Unknown     -1
#define CompletionSize 3

/* Masks */
#define SocketMask   		'\x0F'
#define ReplyMask    		'\xF0'
#define ErrorCatMask 		'\xF0'
#define ErrorNumMask 		'\x0F'
#define UpperMask    		'\xF0'
#define LowerMask    		'\x0F'
#define SearchInProgressMask	'\x02'
#define EditInProgressMask	'\x04'


typedef struct _OutCommand
{
  int socketNum;
  struct _OutCommand* next;
} OutCommand;

/* CVD1000 status */
#define CVD1000StopTapeTop       100
#define CVD1000StopTapeEnd       101
#define CVD1000StopEmergency     102
#define CVD1000ForwardSlow2      103
#define CVD1000ForwardSlow1      104
#define CVD1000ForwardFast1      105
#define CVD1000ReverseSlow2      106
#define CVD1000ReverseSlow1      107
#define CVD1000ReverseFast1      108

int CVD1000Play			(VideoObject*);
int CVD1000PlayFromTo		(VideoObject*, int, int, int);
int CVD1000FastForward		(VideoObject*);
int CVD1000Reverse		(VideoObject*);
int CVD1000CalcSpeed		(VideoObject*, int, int);
int CVD1000PlayAtSpeedDir	(VideoObject*, int, enum Direction);
int CVD1000Step			(VideoObject*, enum Direction);
int CVD1000Still		(VideoObject*);
int CVD1000Stop			(VideoObject*);
int CVD1000SetDefaults		(VideoObject*, int, int, int, int);
int CVD1000SetAudio		(VideoObject*, int);
int CVD1000SetVideo		(VideoObject*, int);
int CVD1000SetAddMode		(VideoObject*, int);
int CVD1000SetAddressDisplay	(VideoObject*, int, int);
int CVD1000Eject		(VideoObject*);
int CVD1000Power		(VideoObject*, int);
int CVD1000QueryFrame		(VideoObject*);
int CVD1000QueryChapter		(VideoObject*);
int CVD1000QueryAudio		(VideoObject*);
int CVD1000QueryVideo		(VideoObject*);
int CVD1000QueryMedium		(VideoObject*, char*);
int CVD1000QueryStatus		(VideoObject*);
int CVD1000Ping			(VideoObject*);
int CVD1000Record		(VideoObject*);
int CVD1000RecordFromTo		(VideoObject*, int, int, int);

void CVD1000PrintErrorMessage	(int, int);
int CVD1000SendCode		(VideoObject*, char, char, char*, int, int);
int CVD1000ReadInquiryReply	(VideoObject*, int);
int CVD1000ReadReply		(VideoObject*);
int CVD1000InputPending		(int);
int CVD1000WaitForCompletion	(VideoObject*);
int CVD1000SearchIsInProgress	(VideoObject*);
int CVD1000EditIsInProgress	(VideoObject*);
