/*
 * Copyright (c) 1990, 1991, 1992 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/VideoObject/RCS/NECDriver.h,v 0.19 92/09/01 17:07:55 drapeau Exp $ */
/* $Log:	NECDriver.h,v $
 * Revision 0.19  92/09/01  17:07:55  drapeau
 * Added function prototypes for better ANSI compliance.
 * Updated copyright notice.
 * Added definitions for two new methods, NECRecord() and NECRecordFromTo().
 * 
 * Revision 0.18  92/07/30  15:20:31  drapeau
 * Removed XView-specific code (header files, in this case).
 * 
 * Revision 0.17  92/01/03  16:49:55  drapeau
 * Removed inclusion of string.h so no conflicts occur with other files that
 * use this driver.
 * 
 * Revision 0.16  91/09/30  17:05:22  lim
 * Added NECPing.
 * 
 * Revision 0.15  91/09/03  16:03:36  lim
 * Red redefined as ScreenRed.
 * 
 * Revision 0.11  91/08/25  16:21:50  lim
 * Included diagMode and PrintDiagnostics().
 * 
 * Revision 0.14  91/08/24  13:37:57  lim
 * 1. Updated to use status codes in new PlayerStatus.h
 * 2. Clear Marker() removed as part of video object.
 * 
 * Revision 0.13  91/08/17  20:44:45  lim
 * NECInterrupt becomes NECClearMarker.
 * 
 * Revision 0.12  91/08/08  16:22:23  lim
 * 1. New include files, so that can compile separately, away from vcrEdit app.
 * 2. Added NECClient (= 200)
 * 3. Changed Error to -100
 * 4. Removed NECPause() and included NECStill() instead.
 * 5. Added NECSetAddressingMode().
 * 
 * Revision 0.11  91/07/20  11:40:57  lim
 * Added new function, NECCalcSpeed().
 * 
 * Revision 0.10  91/07/16  16:13:31  lim
 * Initial revision.
 *  */

#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <sys/termio.h>
#include <sys/time.h>
#include <sys/resource.h>

#ifndef _WaitHeader_
#define _WaitHeader_
#include <sys/wait.h>
#endif

#include "videoObj.h"
#include "PlayerStatus.h"

/*  Defines that need to be included  */

#define NECClient                    200

/* Status codes */
#define NECHiSpeedSearch             1000
#define NECPictureSearch             1001
#define NECRPictureSearch            1002
#define NECRHiSpeedSearch            1003
#define NECForwardIndexScanSearch    1004
#define NECIndexScan                 1005
#define NECReverseIndexScanSearch    1006
#define NECSlow1_30                  1007
#define NECSlow1_10                  1008
#define NECSlow1_5                   1009
#define NECInsertPause               1010
#define NECInsertPlay                1011
#define NECAudioDubPause             1012
#define NECAudioDubPlay              1013
#define NECAudioInsertPause          1014
#define NECAudioInsertPlay           1015

/* Screen colors */

#define Magenta                      1
#define Blue                         2
#define Green                        3
#define Yellow                       4
#define ScreenRed                    5
#define Violet                       6
#define Cyan                         7
#define YellowGreen                  8

#define BrightnessNormal             0
#define BrightnessDim                1
#define BrightnessLow                2

/* Error codes */

#define Error                        -100
#define ErrPowerOff                   0
#define ErrCantReadAdd                1
#define ErrNoCassette                 2
#define ErrIncorrectCommand           4
#define ErrIncorrectParameter         5
#define ErrReceptionBuffOverflow      6
#define ErrCantReadHeader             8 
#define ErrCantExecCommand            9

static char vcrhrcsid[]="$Header: /Source/Media/collab/VideoObject/RCS/NECDriver.h,v 0.19 92/09/01 17:07:55 drapeau Exp $";


int NECPlay			(VideoObject*);
int NECPlayFromTo		(VideoObject*, int, int, int);
int NECFastForward		(VideoObject*);
int NECReverse			(VideoObject*);
int NECCalcSpeed		(VideoObject*, int, int);
int NECPlayAtSpeedDir		(VideoObject*, int, enum Direction);
int NECStep			(VideoObject*, enum Direction);
int NECStill			(VideoObject*);
int NECStop			(VideoObject*);
int NECSetDefaults		(VideoObject*, int, int, int, int);
int NECSetAudio			(VideoObject*, int);
int NECSetVideo			(VideoObject*, int);
int NECSetAddressingMode	(VideoObject*, int);
int NECEject			(VideoObject*);
int NECPower			(VideoObject*, int);
int NECQueryFrame		(VideoObject*);
int NECQueryChapter		(VideoObject*);
int NECQueryAudio		(VideoObject*);
int NECQueryVideo		(VideoObject*);
int NECReadHeader		(VideoObject*, char*);
int NECQueryStatus		(VideoObject*);
int NECPing			(VideoObject*);
int NECRecord			(VideoObject*);
int NECRecordFromTo		(VideoObject*, int, int, int);
void NECErrorDecode		(VideoObject*, int, char*);

