/*
 * cdEdit_ui.c - User interface object initialization functions.
 * This file was generated by `gxv' from `cdEdit.G'.
 * DO NOT EDIT BY HAND.
 */

#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <gcm.h>
#include "cdEdit_ui.h"

/*
 * Create object `DisplayTimeMenu' in the specified instance.
 */
Xv_opaque
cdEdit_DisplayTimeMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	RelativeTimeHandler(Menu_item, Menu_generate);
	extern Menu_item	AbsoluteTimeHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_CHOICE_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Display Time",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Relative",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, RelativeTimeHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Absolute",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, AbsoluteTimeHandler,
			NULL,
		NULL);
	return obj;
}

/*
 * Create object `OptionsMenu' in the specified instance.
 */
Xv_opaque
cdEdit_OptionsMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	InfoHandler(Menu_item, Menu_generate);
	extern Menu_item	ConnectPortManagerHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Options",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "About cdEdit ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, InfoHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Connect with new Port Manager ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, ConnectPortManagerHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Display time",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_PULLRIGHT, cdEdit_DisplayTimeMenu_create(ip, owner),
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Options",
		NULL);
	return obj;
}

/*
 * Create object `DocumentMenu' in the specified instance.
 */
Xv_opaque
cdEdit_DocumentMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	OpenFileHandler(Menu_item, Menu_generate);
	extern Menu_item	SaveFileHandler(Menu_item, Menu_generate);
	extern Menu_item	SaveAsFileHandler(Menu_item, Menu_generate);
	extern Menu_item	CloseFileHandler(Menu_item, Menu_generate);
	extern Menu_item	CloseEditPopupHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Document",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Open",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, OpenFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, SaveFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Save as ... ",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, SaveAsFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, CloseFileHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Close this window",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, CloseEditPopupHandler,
			NULL,
		MENU_GEN_PIN_WINDOW, owner, "Document",
		NULL);
	return obj;
}

/*
 * Create object `PreviewMenu' in the specified instance.
 */
Xv_opaque
cdEdit_PreviewMenu_create(caddr_t ip, Xv_opaque owner)
{
	extern Menu_item	PlayWholeEditHandler(Menu_item, Menu_generate);
	extern Menu_item	PlayPartialEditHandler(Menu_item, Menu_generate);
	Xv_opaque	obj;
	
	obj = xv_create(XV_NULL, MENU_COMMAND_MENU,
		XV_KEY_DATA, INSTANCE, ip,
		MENU_TITLE_ITEM, "Preview",
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play whole edit",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, PlayWholeEditHandler,
			NULL,
		MENU_ITEM,
			XV_KEY_DATA, INSTANCE, ip,
			MENU_STRING, "Play part of edit ...",
			MENU_COLOR, gcm_color_index("Black"),
			MENU_GEN_PROC, PlayPartialEditHandler,
			NULL,
		MENU_DEFAULT, 2,
		MENU_GEN_PIN_WINDOW, owner, "Preview",
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `window1'.
 */
cdEdit_window1_objects *
cdEdit_window1_objects_initialize(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (cdEdit_window1_objects *) calloc(1, sizeof (cdEdit_window1_objects))))
		return (cdEdit_window1_objects *) NULL;
	if (!ip->window1)
		ip->window1 = cdEdit_window1_window1_create(ip, owner);
	if (!ip->MainControl)
		ip->MainControl = cdEdit_window1_MainControl_create(ip, ip->window1);
	if (!ip->OpenOptionsPopupButton)
		ip->OpenOptionsPopupButton = cdEdit_window1_OpenOptionsPopupButton_create(ip, ip->MainControl);
	if (!ip->OpenEditPopupButton)
		ip->OpenEditPopupButton = cdEdit_window1_OpenEditPopupButton_create(ip, ip->MainControl);
	if (!ip->QuitButton)
		ip->QuitButton = cdEdit_window1_QuitButton_create(ip, ip->MainControl);
	if (!ip->TotalTracksMsg)
		ip->TotalTracksMsg = cdEdit_window1_TotalTracksMsg_create(ip, ip->MainControl);
	if (!ip->TimeMsg)
		ip->TimeMsg = cdEdit_window1_TimeMsg_create(ip, ip->MainControl);
	if (!ip->OneButton)
		ip->OneButton = cdEdit_window1_OneButton_create(ip, ip->MainControl);
	if (!ip->TwoButton)
		ip->TwoButton = cdEdit_window1_TwoButton_create(ip, ip->MainControl);
	if (!ip->ThreeButton)
		ip->ThreeButton = cdEdit_window1_ThreeButton_create(ip, ip->MainControl);
	if (!ip->FourButton)
		ip->FourButton = cdEdit_window1_FourButton_create(ip, ip->MainControl);
	if (!ip->FiveButton)
		ip->FiveButton = cdEdit_window1_FiveButton_create(ip, ip->MainControl);
	if (!ip->SixButton)
		ip->SixButton = cdEdit_window1_SixButton_create(ip, ip->MainControl);
	if (!ip->SevenButton)
		ip->SevenButton = cdEdit_window1_SevenButton_create(ip, ip->MainControl);
	if (!ip->EightButton)
		ip->EightButton = cdEdit_window1_EightButton_create(ip, ip->MainControl);
	if (!ip->NineButton)
		ip->NineButton = cdEdit_window1_NineButton_create(ip, ip->MainControl);
	if (!ip->ZeroButton)
		ip->ZeroButton = cdEdit_window1_ZeroButton_create(ip, ip->MainControl);
	if (!ip->SearchButton)
		ip->SearchButton = cdEdit_window1_SearchButton_create(ip, ip->MainControl);
	if (!ip->SearchTrackText)
		ip->SearchTrackText = cdEdit_window1_SearchTrackText_create(ip, ip->MainControl);
	if (!ip->DurationLabelMsg)
		ip->DurationLabelMsg = cdEdit_window1_DurationLabelMsg_create(ip, ip->MainControl);
	if (!ip->DurationTimeMsg)
		ip->DurationTimeMsg = cdEdit_window1_DurationTimeMsg_create(ip, ip->MainControl);
	if (!ip->TempDurationMsg)
		ip->TempDurationMsg = cdEdit_window1_TempDurationMsg_create(ip, ip->MainControl);
	if (!ip->DurationSlider)
		ip->DurationSlider = cdEdit_window1_DurationSlider_create(ip, ip->MainControl);
	if (!ip->PauseButton)
		ip->PauseButton = cdEdit_window1_PauseButton_create(ip, ip->MainControl);
	if (!ip->StopButton)
		ip->StopButton = cdEdit_window1_StopButton_create(ip, ip->MainControl);
	if (!ip->PlayButton)
		ip->PlayButton = cdEdit_window1_PlayButton_create(ip, ip->MainControl);
	if (!ip->ReverseSkipButton)
		ip->ReverseSkipButton = cdEdit_window1_ReverseSkipButton_create(ip, ip->MainControl);
	if (!ip->EjectButton)
		ip->EjectButton = cdEdit_window1_EjectButton_create(ip, ip->MainControl);
	if (!ip->ForwardSkipButton)
		ip->ForwardSkipButton = cdEdit_window1_ForwardSkipButton_create(ip, ip->MainControl);
	if (!ip->VolumeSlider)
		ip->VolumeSlider = cdEdit_window1_VolumeSlider_create(ip, ip->MainControl);
	if (!ip->BalanceSlider)
		ip->BalanceSlider = cdEdit_window1_BalanceSlider_create(ip, ip->MainControl);
	return ip;
}

/*
 * Create object `window1' in the specified instance.
 */
Xv_opaque
cdEdit_window1_window1_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	Xv_opaque		window1_image;
	static unsigned short	window1_bits[] = {
#include "icons/cdEditIcon"
	};
	
	window1_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, window1_bits,
		XV_WIDTH, 64,
		XV_HEIGHT, 64,
		NULL);
	obj = xv_create(owner, FRAME,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 238,
		XV_HEIGHT, 386,
		XV_LABEL, "cdEdit",
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_ICON, xv_create(XV_NULL, ICON,
			ICON_IMAGE, window1_image,
			NULL),
		NULL);
	gcm_initialize_colors(obj, "Black", NULL);
	return obj;
}

/*
 * Create object `MainControl' in the specified instance.
 */
Xv_opaque
cdEdit_window1_MainControl_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, 237,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", "Black");
	return obj;
}

/*
 * Create object `OpenOptionsPopupButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_OpenOptionsPopupButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Options",
		PANEL_ITEM_MENU, cdEdit_OptionsMenu_create((caddr_t) ip, ip->window1),
		NULL);
	return obj;
}

/*
 * Create object `OpenEditPopupButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_OpenEditPopupButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Edit(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Edit...",
		PANEL_NOTIFY_PROC, Edit,
		NULL);
	return obj;
}

/*
 * Create object `QuitButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_QuitButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Quit(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Quit  ",
		PANEL_NOTIFY_PROC, Quit,
		NULL);
	return obj;
}

/*
 * Create object `TotalTracksMsg' in the specified instance.
 */
Xv_opaque
cdEdit_window1_TotalTracksMsg_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Total Tracks : 00",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `TimeMsg' in the specified instance.
 */
Xv_opaque
cdEdit_window1_TimeMsg_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 140,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Time : 00:00",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `OneButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_OneButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		One(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 80,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    1    ",
		PANEL_NOTIFY_PROC, One,
		NULL);
	return obj;
}

/*
 * Create object `TwoButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_TwoButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Two(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 80,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    2    ",
		PANEL_NOTIFY_PROC, Two,
		NULL);
	return obj;
}

/*
 * Create object `ThreeButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_ThreeButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Three(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 80,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    3    ",
		PANEL_NOTIFY_PROC, Three,
		NULL);
	return obj;
}

/*
 * Create object `FourButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_FourButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Four(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 104,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    4    ",
		PANEL_NOTIFY_PROC, Four,
		NULL);
	return obj;
}

/*
 * Create object `FiveButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_FiveButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Five(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 104,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    5    ",
		PANEL_NOTIFY_PROC, Five,
		NULL);
	return obj;
}

/*
 * Create object `SixButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_SixButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Six(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 104,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    6    ",
		PANEL_NOTIFY_PROC, Six,
		NULL);
	return obj;
}

/*
 * Create object `SevenButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_SevenButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Seven(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 128,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    7    ",
		PANEL_NOTIFY_PROC, Seven,
		NULL);
	return obj;
}

/*
 * Create object `EightButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_EightButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Eight(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 128,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    8    ",
		PANEL_NOTIFY_PROC, Eight,
		NULL);
	return obj;
}

/*
 * Create object `NineButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_NineButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Nine(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 160,
		XV_Y, 128,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    9    ",
		PANEL_NOTIFY_PROC, Nine,
		NULL);
	return obj;
}

/*
 * Create object `ZeroButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_ZeroButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Zero(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 88,
		XV_Y, 152,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    0    ",
		PANEL_NOTIFY_PROC, Zero,
		NULL);
	return obj;
}

/*
 * Create object `SearchButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_SearchButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Search(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 176,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Search",
		PANEL_NOTIFY_PROC, Search,
		NULL);
	return obj;
}

/*
 * Create object `SearchTrackText' in the specified instance.
 */
Xv_opaque
cdEdit_window1_SearchTrackText_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	SearchKbd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 76,
		XV_Y, 180,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " for track",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_MAX_VALUE, 99,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, SearchKbd,
		NULL);
	return obj;
}

/*
 * Create object `DurationLabelMsg' in the specified instance.
 */
Xv_opaque
cdEdit_window1_DurationLabelMsg_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 48,
		XV_Y, 200,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Track Duration",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `DurationTimeMsg' in the specified instance.
 */
Xv_opaque
cdEdit_window1_DurationTimeMsg_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 200,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "00:00",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `TempDurationMsg' in the specified instance.
 */
Xv_opaque
cdEdit_window1_TempDurationMsg_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 216,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "00:00",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `DurationSlider' in the specified instance.
 */
Xv_opaque
cdEdit_window1_DurationSlider_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Duration(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 232,
		PANEL_SLIDER_WIDTH, 210,
		PANEL_TICKS, 5,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 0,
		PANEL_MAX_VALUE, 100,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, Duration,
		NULL);
	return obj;
}

/*
 * Create object `PauseButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_PauseButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Pause(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		PauseButton_image;
	static unsigned short	PauseButton_bits[] = {
#include "icons/pauseIcon"
	};
	
	PauseButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, PauseButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 260,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, PauseButton_image,
		PANEL_NOTIFY_PROC, Pause,
		NULL);
	return obj;
}

/*
 * Create object `StopButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_StopButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Stop(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		StopButton_image;
	static unsigned short	StopButton_bits[] = {
#include "icons/stopIcon"
	};
	
	StopButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, StopButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 96,
		XV_Y, 260,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, StopButton_image,
		PANEL_NOTIFY_PROC, Stop,
		NULL);
	return obj;
}

/*
 * Create object `PlayButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_PlayButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Play(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		PlayButton_image;
	static unsigned short	PlayButton_bits[] = {
#include "icons/playIcon"
	};
	
	PlayButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, PlayButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 15,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 260,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, PlayButton_image,
		PANEL_NOTIFY_PROC, Play,
		NULL);
	return obj;
}

/*
 * Create object `ReverseSkipButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_ReverseSkipButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ReverseSkip(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		ReverseSkipButton_image;
	static unsigned short	ReverseSkipButton_bits[] = {
#include "icons/rSkipIcon"
	};
	
	ReverseSkipButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, ReverseSkipButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 20,
		XV_Y, 292,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, ReverseSkipButton_image,
		PANEL_NOTIFY_PROC, ReverseSkip,
		NULL);
	return obj;
}

/*
 * Create object `EjectButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_EjectButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Eject(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		EjectButton_image;
	static unsigned short	EjectButton_bits[] = {
#include "icons/ejectIcon"
	};
	
	EjectButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, EjectButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 96,
		XV_Y, 292,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, EjectButton_image,
		PANEL_NOTIFY_PROC, Eject,
		NULL);
	return obj;
}

/*
 * Create object `ForwardSkipButton' in the specified instance.
 */
Xv_opaque
cdEdit_window1_ForwardSkipButton_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		ForwardSkip(Panel_item, Event *);
	Xv_opaque	obj;
	Xv_opaque		ForwardSkipButton_image;
	static unsigned short	ForwardSkipButton_bits[] = {
#include "icons/fSkipIcon"
	};
	
	ForwardSkipButton_image = xv_create(XV_NULL, SERVER_IMAGE,
		SERVER_IMAGE_DEPTH, 1,
		SERVER_IMAGE_BITS, ForwardSkipButton_bits,
		XV_WIDTH, 32,
		XV_HEIGHT, 12,
		NULL);
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 292,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_IMAGE, ForwardSkipButton_image,
		PANEL_NOTIFY_PROC, ForwardSkip,
		NULL);
	return obj;
}

/*
 * Create object `VolumeSlider' in the specified instance.
 */
Xv_opaque
cdEdit_window1_VolumeSlider_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Volume(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 324,
		PANEL_SLIDER_WIDTH, 140,
		PANEL_TICKS, 3,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Volume  ",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, 110,
		PANEL_MAX_VALUE, 250,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, Volume,
		NULL);
	return obj;
}

/*
 * Create object `BalanceSlider' in the specified instance.
 */
Xv_opaque
cdEdit_window1_BalanceSlider_create(cdEdit_window1_objects *ip, Xv_opaque owner)
{
	extern void		Balance(Panel_item, int, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_SLIDER,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 352,
		PANEL_SLIDER_WIDTH, 140,
		PANEL_TICKS, 3,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Balance  ",
		PANEL_DIRECTION, PANEL_HORIZONTAL,
		PANEL_SLIDER_END_BOXES, FALSE,
		PANEL_SHOW_RANGE, FALSE,
		PANEL_SHOW_VALUE, FALSE,
		PANEL_MIN_VALUE, -15,
		PANEL_MAX_VALUE, 15,
		PANEL_VALUE, 0,
		PANEL_NOTIFY_PROC, Balance,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `EditPopup'.
 */
cdEdit_EditPopup_objects *
cdEdit_EditPopup_objects_initialize(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (cdEdit_EditPopup_objects *) calloc(1, sizeof (cdEdit_EditPopup_objects))))
		return (cdEdit_EditPopup_objects *) NULL;
	if (!ip->EditPopup)
		ip->EditPopup = cdEdit_EditPopup_EditPopup_create(ip, owner);
	if (!ip->EditFileControl)
		ip->EditFileControl = cdEdit_EditPopup_EditFileControl_create(ip, ip->EditPopup);
	if (!ip->DocumentButton)
		ip->DocumentButton = cdEdit_EditPopup_DocumentButton_create(ip, ip->EditFileControl);
	if (!ip->DiscLabelText)
		ip->DiscLabelText = cdEdit_EditPopup_DiscLabelText_create(ip, ip->EditFileControl);
	if (!ip->EditListControl)
		ip->EditListControl = cdEdit_EditPopup_EditListControl_create(ip, ip->EditPopup);
	if (!ip->EditListMainHeaderMsg)
		ip->EditListMainHeaderMsg = cdEdit_EditPopup_EditListMainHeaderMsg_create(ip, ip->EditListControl);
	if (!ip->EditListNumEditsMsg)
		ip->EditListNumEditsMsg = cdEdit_EditPopup_EditListNumEditsMsg_create(ip, ip->EditListControl);
	if (!ip->EditListHeaderMsg1)
		ip->EditListHeaderMsg1 = cdEdit_EditPopup_EditListHeaderMsg1_create(ip, ip->EditListControl);
	if (!ip->EditListHeaderMsg2)
		ip->EditListHeaderMsg2 = cdEdit_EditPopup_EditListHeaderMsg2_create(ip, ip->EditListControl);
	if (!ip->EditList)
		ip->EditList = cdEdit_EditPopup_EditList_create(ip, ip->EditListControl);
	if (!ip->EditCurrentSelectionControl)
		ip->EditCurrentSelectionControl = cdEdit_EditPopup_EditCurrentSelectionControl_create(ip, ip->EditPopup);
	if (!ip->CurrentSelectionMsg)
		ip->CurrentSelectionMsg = cdEdit_EditPopup_CurrentSelectionMsg_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->CurrentSelectionTimeMsg)
		ip->CurrentSelectionTimeMsg = cdEdit_EditPopup_CurrentSelectionTimeMsg_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupStartTrackText)
		ip->EditPopupStartTrackText = cdEdit_EditPopup_EditPopupStartTrackText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->TimeColonMsg4)
		ip->TimeColonMsg4 = cdEdit_EditPopup_TimeColonMsg4_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupStartMinText)
		ip->EditPopupStartMinText = cdEdit_EditPopup_EditPopupStartMinText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->TimeColonMsg6)
		ip->TimeColonMsg6 = cdEdit_EditPopup_TimeColonMsg6_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupStartSecText)
		ip->EditPopupStartSecText = cdEdit_EditPopup_EditPopupStartSecText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->TimeColonMsg2)
		ip->TimeColonMsg2 = cdEdit_EditPopup_TimeColonMsg2_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupStartFrameText)
		ip->EditPopupStartFrameText = cdEdit_EditPopup_EditPopupStartFrameText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->GetStartButton)
		ip->GetStartButton = cdEdit_EditPopup_GetStartButton_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->GetTimeMsg1)
		ip->GetTimeMsg1 = cdEdit_EditPopup_GetTimeMsg1_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupEndTrackText)
		ip->EditPopupEndTrackText = cdEdit_EditPopup_EditPopupEndTrackText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->TimeColonMsg5)
		ip->TimeColonMsg5 = cdEdit_EditPopup_TimeColonMsg5_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupEndMinText)
		ip->EditPopupEndMinText = cdEdit_EditPopup_EditPopupEndMinText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->TimeColonMsg1)
		ip->TimeColonMsg1 = cdEdit_EditPopup_TimeColonMsg1_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupEndSecText)
		ip->EditPopupEndSecText = cdEdit_EditPopup_EditPopupEndSecText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->TimeColonMsg3)
		ip->TimeColonMsg3 = cdEdit_EditPopup_TimeColonMsg3_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupEndFrameText)
		ip->EditPopupEndFrameText = cdEdit_EditPopup_EditPopupEndFrameText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->GetEndButton)
		ip->GetEndButton = cdEdit_EditPopup_GetEndButton_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->GetTimeMsg2)
		ip->GetTimeMsg2 = cdEdit_EditPopup_GetTimeMsg2_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupLabelText)
		ip->EditPopupLabelText = cdEdit_EditPopup_EditPopupLabelText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->OpenPreviewPopupButton)
		ip->OpenPreviewPopupButton = cdEdit_EditPopup_OpenPreviewPopupButton_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->EditPopupDurationText)
		ip->EditPopupDurationText = cdEdit_EditPopup_EditPopupDurationText_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->DurationMsg)
		ip->DurationMsg = cdEdit_EditPopup_DurationMsg_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->AddButton)
		ip->AddButton = cdEdit_EditPopup_AddButton_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->ModifyButton)
		ip->ModifyButton = cdEdit_EditPopup_ModifyButton_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->DeleteButton)
		ip->DeleteButton = cdEdit_EditPopup_DeleteButton_create(ip, ip->EditCurrentSelectionControl);
	if (!ip->DeleteAllButton)
		ip->DeleteAllButton = cdEdit_EditPopup_DeleteAllButton_create(ip, ip->EditCurrentSelectionControl);
	return ip;
}

/*
 * Create object `EditPopup' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopup_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 496,
		XV_HEIGHT, 448,
		XV_LABEL, "CD Edit",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, TRUE,
		NULL);
	gcm_initialize_colors(obj, "Black", NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `EditFileControl' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditFileControl_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 48,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", "Black");
	return obj;
}

/*
 * Create object `DocumentButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_DocumentButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 24,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Document",
		PANEL_ITEM_MENU, cdEdit_DocumentMenu_create((caddr_t) ip, ip->EditPopup),
		NULL);
	return obj;
}

/*
 * Create object `DiscLabelText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_DiscLabelText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 136,
		XV_Y, 16,
		PANEL_VALUE_DISPLAY_LENGTH, 32,
		PANEL_VALUE_STORED_LENGTH, 256,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Disc Label : ",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EditListControl' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditListControl_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 49,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, 215,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", "Black");
	return obj;
}

/*
 * Create object `EditListMainHeaderMsg' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditListMainHeaderMsg_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Edit List",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditListNumEditsMsg' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditListNumEditsMsg_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 372,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "No. of Edits : 0",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EditListHeaderMsg1' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditListHeaderMsg1_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 32,
		XV_Y, 36,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Edit #                          Label   ",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EditListHeaderMsg2' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditListHeaderMsg2_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 312,
		XV_Y, 36,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Start               End",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EditList' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditList_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern int		List(Panel_item, char *, Xv_opaque, Panel_list_op, Event *, int);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_LIST,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 56,
		PANEL_LIST_WIDTH, 460,
		PANEL_LIST_DISPLAY_ROWS, 7,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_CHOOSE_ONE, TRUE,
		PANEL_CHOOSE_NONE, TRUE,
		PANEL_NOTIFY_PROC, List,
		NULL);
	return obj;
}

/*
 * Create object `EditCurrentSelectionControl' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditCurrentSelectionControl_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 265,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", "Black");
	return obj;
}

/*
 * Create object `CurrentSelectionMsg' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_CurrentSelectionMsg_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 12,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Current Selection : None",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `CurrentSelectionTimeMsg' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_CurrentSelectionTimeMsg_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 64,
		XV_Y, 36,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Track      Min       Sec      Frame",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupStartTrackText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupStartTrackText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 52,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Start :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `TimeColonMsg4' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_TimeColonMsg4_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, ":",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupStartMinText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupStartMinText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 52,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `TimeColonMsg6' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_TimeColonMsg6_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 156,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, ":",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupStartSecText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupStartSecText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 156,
		XV_Y, 52,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `TimeColonMsg2' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_TimeColonMsg2_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 208,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, ":",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupStartFrameText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupStartFrameText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 208,
		XV_Y, 52,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `GetStartButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_GetStartButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern void		GetStart(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 264,
		XV_Y, 52,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "<-",
		PANEL_NOTIFY_PROC, GetStart,
		NULL);
	return obj;
}

/*
 * Create object `GetTimeMsg1' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_GetTimeMsg1_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 304,
		XV_Y, 60,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Get current time",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupEndTrackText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupEndTrackText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 76,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "End   :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `TimeColonMsg5' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_TimeColonMsg5_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, ":",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupEndMinText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupEndMinText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 104,
		XV_Y, 76,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `TimeColonMsg1' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_TimeColonMsg1_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 156,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, ":",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupEndSecText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupEndSecText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 156,
		XV_Y, 76,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `TimeColonMsg3' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_TimeColonMsg3_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 208,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, ":",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupEndFrameText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupEndFrameText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 208,
		XV_Y, 76,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `GetEndButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_GetEndButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern void		GetEnd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 264,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "<-",
		PANEL_NOTIFY_PROC, GetEnd,
		NULL);
	return obj;
}

/*
 * Create object `GetTimeMsg2' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_GetTimeMsg2_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 324,
		XV_Y, 76,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "from disc",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `EditPopupLabelText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupLabelText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern Panel_setting	LabelText(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 100,
		PANEL_VALUE_DISPLAY_LENGTH, 25,
		PANEL_VALUE_STORED_LENGTH, 256,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Label :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, FALSE,
		PANEL_NOTIFY_PROC, LabelText,
		NULL);
	return obj;
}

/*
 * Create object `OpenPreviewPopupButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_OpenPreviewPopupButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 376,
		XV_Y, 112,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Preview",
		PANEL_ITEM_MENU, cdEdit_PreviewMenu_create((caddr_t) ip, ip->EditPopup),
		NULL);
	return obj;
}

/*
 * Create object `EditPopupDurationText' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_EditPopupDurationText_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 16,
		XV_Y, 124,
		PANEL_VALUE_DISPLAY_LENGTH, 8,
		PANEL_VALUE_STORED_LENGTH, 80,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Approximate duration :",
		PANEL_LAYOUT, PANEL_HORIZONTAL,
		PANEL_READ_ONLY, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `DurationMsg' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_DurationMsg_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 252,
		XV_Y, 124,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "seconds",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `AddButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_AddButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditAdd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 32,
		XV_Y, 152,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "    Add",
		PANEL_NOTIFY_PROC, EditAdd,
		NULL);
	return obj;
}

/*
 * Create object `ModifyButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_ModifyButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditModify(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 144,
		XV_Y, 152,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Modify",
		PANEL_NOTIFY_PROC, EditModify,
		NULL);
	return obj;
}

/*
 * Create object `DeleteButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_DeleteButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditDelete(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 264,
		XV_Y, 152,
		PANEL_LABEL_WIDTH, 57,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "  Delete",
		PANEL_NOTIFY_PROC, EditDelete,
		NULL);
	return obj;
}

/*
 * Create object `DeleteAllButton' in the specified instance.
 */
Xv_opaque
cdEdit_EditPopup_DeleteAllButton_create(cdEdit_EditPopup_objects *ip, Xv_opaque owner)
{
	extern void		EditDeleteAll(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 376,
		XV_Y, 152,
		PANEL_LABEL_WIDTH, 65,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Delete All",
		PANEL_NOTIFY_PROC, EditDeleteAll,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `PreviewPopup'.
 */
cdEdit_PreviewPopup_objects *
cdEdit_PreviewPopup_objects_initialize(cdEdit_PreviewPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (cdEdit_PreviewPopup_objects *) calloc(1, sizeof (cdEdit_PreviewPopup_objects))))
		return (cdEdit_PreviewPopup_objects *) NULL;
	if (!ip->PreviewPopup)
		ip->PreviewPopup = cdEdit_PreviewPopup_PreviewPopup_create(ip, owner);
	if (!ip->PreviewControl)
		ip->PreviewControl = cdEdit_PreviewPopup_PreviewControl_create(ip, ip->PreviewPopup);
	if (!ip->PreviewStartButton)
		ip->PreviewStartButton = cdEdit_PreviewPopup_PreviewStartButton_create(ip, ip->PreviewControl);
	if (!ip->PreviewTimeText)
		ip->PreviewTimeText = cdEdit_PreviewPopup_PreviewTimeText_create(ip, ip->PreviewControl);
	if (!ip->PreviewEndButton)
		ip->PreviewEndButton = cdEdit_PreviewPopup_PreviewEndButton_create(ip, ip->PreviewControl);
	if (!ip->ClosePreviewPopupButton)
		ip->ClosePreviewPopupButton = cdEdit_PreviewPopup_ClosePreviewPopupButton_create(ip, ip->PreviewControl);
	return ip;
}

/*
 * Create object `PreviewPopup' in the specified instance.
 */
Xv_opaque
cdEdit_PreviewPopup_PreviewPopup_create(cdEdit_PreviewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 188,
		XV_HEIGHT, 115,
		XV_LABEL, "CD Preview",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `PreviewControl' in the specified instance.
 */
Xv_opaque
cdEdit_PreviewPopup_PreviewControl_create(cdEdit_PreviewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", "Black");
	return obj;
}

/*
 * Create object `PreviewStartButton' in the specified instance.
 */
Xv_opaque
cdEdit_PreviewPopup_PreviewStartButton_create(cdEdit_PreviewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewStart(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 16,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Play first  ",
		PANEL_NOTIFY_PROC, PreviewStart,
		NULL);
	return obj;
}

/*
 * Create object `PreviewTimeText' in the specified instance.
 */
Xv_opaque
cdEdit_PreviewPopup_PreviewTimeText_create(cdEdit_PreviewPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_NUMERIC_TEXT,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 100,
		XV_Y, 24,
		PANEL_VALUE_DISPLAY_LENGTH, 2,
		PANEL_VALUE_STORED_LENGTH, 2,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "seconds",
		PANEL_LAYOUT, PANEL_VERTICAL,
		PANEL_MAX_VALUE, 60,
		PANEL_MIN_VALUE, 0,
		PANEL_VALUE, 0,
		PANEL_READ_ONLY, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `PreviewEndButton' in the specified instance.
 */
Xv_opaque
cdEdit_PreviewPopup_PreviewEndButton_create(cdEdit_PreviewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewEnd(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 12,
		XV_Y, 48,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Play last   ",
		PANEL_NOTIFY_PROC, PreviewEnd,
		NULL);
	return obj;
}

/*
 * Create object `ClosePreviewPopupButton' in the specified instance.
 */
Xv_opaque
cdEdit_PreviewPopup_ClosePreviewPopupButton_create(cdEdit_PreviewPopup_objects *ip, Xv_opaque owner)
{
	extern void		PreviewDone(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 72,
		XV_Y, 84,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Done",
		PANEL_NOTIFY_PROC, PreviewDone,
		NULL);
	return obj;
}

/*
 * Initialize an instance of object `InfoPopup'.
 */
cdEdit_InfoPopup_objects *
cdEdit_InfoPopup_objects_initialize(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	if (!ip && !(ip = (cdEdit_InfoPopup_objects *) calloc(1, sizeof (cdEdit_InfoPopup_objects))))
		return (cdEdit_InfoPopup_objects *) NULL;
	if (!ip->InfoPopup)
		ip->InfoPopup = cdEdit_InfoPopup_InfoPopup_create(ip, owner);
	if (!ip->InfoControl)
		ip->InfoControl = cdEdit_InfoPopup_InfoControl_create(ip, ip->InfoPopup);
	if (!ip->InfoTitleMsg)
		ip->InfoTitleMsg = cdEdit_InfoPopup_InfoTitleMsg_create(ip, ip->InfoControl);
	if (!ip->VersionMsg)
		ip->VersionMsg = cdEdit_InfoPopup_VersionMsg_create(ip, ip->InfoControl);
	if (!ip->InfoByMsg)
		ip->InfoByMsg = cdEdit_InfoPopup_InfoByMsg_create(ip, ip->InfoControl);
	if (!ip->InfoNameMsg)
		ip->InfoNameMsg = cdEdit_InfoPopup_InfoNameMsg_create(ip, ip->InfoControl);
	if (!ip->InfoCopyrightMsg)
		ip->InfoCopyrightMsg = cdEdit_InfoPopup_InfoCopyrightMsg_create(ip, ip->InfoControl);
	if (!ip->InfoStanfordMsg)
		ip->InfoStanfordMsg = cdEdit_InfoPopup_InfoStanfordMsg_create(ip, ip->InfoControl);
	if (!ip->InfoEmailMsg)
		ip->InfoEmailMsg = cdEdit_InfoPopup_InfoEmailMsg_create(ip, ip->InfoControl);
	if (!ip->moreinfoMessage)
		ip->moreinfoMessage = cdEdit_InfoPopup_moreinfoMessage_create(ip, ip->InfoControl);
	if (!ip->CloseInfoPopupButton)
		ip->CloseInfoPopupButton = cdEdit_InfoPopup_CloseInfoPopupButton_create(ip, ip->InfoControl);
	return ip;
}

/*
 * Create object `InfoPopup' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoPopup_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, FRAME_CMD,
		XV_KEY_DATA, INSTANCE, ip,
		XV_WIDTH, 477,
		XV_HEIGHT, 263,
		XV_LABEL, "Info",
		XV_SHOW, FALSE,
		FRAME_SHOW_FOOTER, TRUE,
		FRAME_SHOW_RESIZE_CORNER, FALSE,
		FRAME_CMD_PUSHPIN_IN, FALSE,
		NULL);
	xv_set(xv_get(obj, FRAME_CMD_PANEL), WIN_SHOW, FALSE, NULL);
	return obj;
}

/*
 * Create object `InfoControl' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoControl_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		WIN_BORDER, FALSE,
		NULL);
	gcm_initialize_colors(obj, "Light Gray", "Black");
	return obj;
}

/*
 * Create object `InfoTitleMsg' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoTitleMsg_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 168,
		XV_Y, 8,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "CD Edit   Version 2.10",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `VersionMsg' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_VersionMsg_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 71,
		XV_Y, 36,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "An application for annotating music from compact disc",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `InfoByMsg' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoByMsg_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 23,
		XV_Y, 56,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "designed for use with the MAEstro Multimedia Authoring Environment",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `InfoNameMsg' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoNameMsg_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 177,
		XV_Y, 96,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "by Teck-Joo Chua",
		PANEL_LABEL_BOLD, TRUE,
		NULL);
	return obj;
}

/*
 * Create object `InfoCopyrightMsg' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoCopyrightMsg_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 8,
		XV_Y, 136,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Copyright (C) 1990, 1991, 1992 Libraries and Information Resources (L&IR)",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `InfoStanfordMsg' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoStanfordMsg_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 176,
		XV_Y, 168,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, " Stanford University",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `InfoEmailMsg' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_InfoEmailMsg_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 179,
		XV_Y, 184,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "Stanford, California",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `moreinfoMessage' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_moreinfoMessage_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_MESSAGE,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 84,
		XV_Y, 204,
		PANEL_LABEL_STRING, "For more info, contact maestro@sioux.stanford.edu",
		PANEL_LABEL_BOLD, FALSE,
		NULL);
	return obj;
}

/*
 * Create object `CloseInfoPopupButton' in the specified instance.
 */
Xv_opaque
cdEdit_InfoPopup_CloseInfoPopupButton_create(cdEdit_InfoPopup_objects *ip, Xv_opaque owner)
{
	extern void		InfoDone(Panel_item, Event *);
	Xv_opaque	obj;
	
	obj = xv_create(owner, PANEL_BUTTON,
		XV_KEY_DATA, INSTANCE, ip,
		XV_X, 220,
		XV_Y, 240,
		PANEL_ITEM_COLOR, gcm_color_index("Black"),
		PANEL_LABEL_STRING, "OK",
		PANEL_NOTIFY_PROC, InfoDone,
		NULL);
	return obj;
}

