/*
 * Copyright (c) 1990, 1991 Stanford University
 *
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the name
 * Stanford may not be used in any advertising or publicity relating to
 * the software without the specific, prior written permission of
 * Stanford.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD BE LIABLE FOR ANY SPECIAL, INCIDENTAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND, OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER OR NOT
 * ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF LIABILITY,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 */

/* $Header: /Source/Media/collab/cdEdit/RCS/preview.c,v 2.1 92/07/17 16:35:04 drapeau Exp $ */
/* $Log:	preview.c,v $
 * Revision 2.1  92/07/17  16:35:04  drapeau
 * Minor changes to PreviewStart(), PreviewEnd(), to make
 * overflow code more robust (can now handle overflows of greater than
 * one second).
 * 
 * Revision 2.0  91/10/06  21:01:52  chua
 * Update to version 2.0
 * 
 * Revision 1.11  91/09/03  15:23:24  chua
 * Added the copyright header.
 * 
 * The preview button has now been changed to a menu button, with 2 entries: Play whole
 * edit, and Play part of edit.  The handlers for these two items are in this file.
 * 
 * Play part of edit will open the preview popup window, which allows playing the first or
 * last few seconds of an edit (as previously).  
 * 
 * Revision 1.1  91/07/09  16:48:02  chua
 * 
 * 
 * Revision 1.0  91/07/08  13:46:30  chua
 * Initial revision
 *  */

static char previewrcsid[] = "$Header: /Source/Media/collab/cdEdit/RCS/preview.c,v 2.1 92/07/17 16:35:04 drapeau Exp $";

#include "main.h"

/*
 * Menu handler for `PreviewMenu (Play whole edit)'.
 * Calls PreviewStartEnd to play the whole edit.
 */
Menu_item PlayWholeEditHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    if (SetDuration(-1) != Error)				    /* Display the duration of the current selection */
    {
      PreviewStartEnd(item, NULL);
    }
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Menu handler for `PreviewMenu (Play part of edit ...)'.
 * Opens the preview popup window so that the user can choose to play either the first or last parts of an edit.
 */
Menu_item PlayPartialEditHandler(item, op)
     Menu_item	item;
     Menu_generate	op;
{
  switch (op) 
  {
   case MENU_DISPLAY:
    break;
   case MENU_DISPLAY_DONE:
    break;
   case MENU_NOTIFY:
    SetDuration(-1);						    /* Display the duration of the current selection */
    xv_set(cdEdit_PreviewPopup->PreviewPopup, FRAME_CMD_PUSHPIN_IN, TRUE, NULL);
    xv_set(cdEdit_PreviewPopup->PreviewPopup, XV_SHOW, TRUE, NULL);
    break;
   case MENU_NOTIFY_DONE:
    break;
  }
  return item;
}

/*
 * Notify callback function for `PreviewStartEndButton'.
 * Preview the current selection from start to end.
 * This function is also called by the PerformSelection procedure as the selection to be performed would have been loaded into the current selection
 * textfields by the time this function is called.
 */
void PreviewStartEnd(item, event)
     Panel_item	item;
     Event		*event;
{
  Msf absoluteStart, absoluteEnd;
  struct cdrom_msf msf;
  
  if (offset == 1) 
  {
    absoluteStart = offsetStart;				    /* There is an offset.  Play from the offset start time instead */
    offset = 0;
  }
  else 
  {
    absoluteStart = (Msf) GetCurrentStart();			    /* Get the start time */
  }
  absoluteEnd = NULL;
  if (absoluteStart == NULL) 
  {
    return;
  }
  absoluteEnd = (Msf) GetCurrentEnd();				    /* Get the end time */
  if (absoluteEnd == NULL) 
  {
    return;
  }
  if (CheckSelection(absoluteStart, absoluteEnd) == Error)	    /* Check that the selection is valid */
  {
    return;
  }
  msf.cdmsf_min0 = absoluteStart->min;				    /* Set the time limits to play from/to. */
  msf.cdmsf_sec0 = absoluteStart->sec;
  msf.cdmsf_frame0 = absoluteStart->frame;
  msf.cdmsf_min1 = absoluteEnd->min;
  msf.cdmsf_sec1 = absoluteEnd->sec;
  msf.cdmsf_frame1 = absoluteEnd->frame;
  playerState = PlayMode;
  cdrom_play_msf(fd, msf);
}

/*
 * Notify callback function for `PreviewStartButton'.
 * Preview the first x seconds of the current selection.
 */
void PreviewStart(item, event)
     Panel_item	item;
     Event		*event;
{
  Msf absoluteStart, absoluteEnd, endMsf;
  struct cdrom_msf msf;
  int duration;
  
  absoluteStart = (Msf) GetCurrentStart();			    /* Get the start time */
  absoluteEnd = NULL;
  if (absoluteStart == NULL)	
  {
    return;
  }
  absoluteEnd = (Msf) GetCurrentEnd();				    /* Get the end time */
  if (absoluteEnd == NULL) 
  {
    return;
  }
  if (CheckSelection(absoluteStart, absoluteEnd) == Error)	    /* Check that the times are valid */
  {
    return;
  }
  duration = xv_get(cdEdit_PreviewPopup->PreviewTimeText, PANEL_VALUE);	/* Get the duration that the preview is to be played */
  endMsf = (Msf) malloc(sizeof(struct msf));			    /* Set the end time based on the duration */
  endMsf->min = absoluteStart->min; 
  endMsf->sec = absoluteStart->sec + duration;
  endMsf->frame = absoluteStart->frame;
  while (endMsf->sec >= 60) 
  {
    endMsf->sec -= 60;
    endMsf->min++;
  }
  if (CompareMsf(endMsf, absoluteEnd) == Greater) 
  {
    endMsf = absoluteEnd;
  }
  msf.cdmsf_min0 = absoluteStart->min;				    /* Set the time limits to play from/to */
  msf.cdmsf_sec0 = absoluteStart->sec;
  msf.cdmsf_frame0 = absoluteStart->frame;
  msf.cdmsf_min1 = endMsf->min;
  msf.cdmsf_sec1 = endMsf->sec;
  msf.cdmsf_frame1 = endMsf->frame;
  playerState = PlayMode;
  cdrom_play_msf(fd, msf);
  free (endMsf);
}

/*
 * Notify callback function for `PreviewEndButton'.
 * Preview the last x seconds of the current selection.
 */
void PreviewEnd(item, event)
     Panel_item	item;
     Event		*event;
{
  Msf absoluteStart, absoluteEnd, startMsf;
  struct cdrom_msf msf;
  int duration;
  
  absoluteStart = (Msf) GetCurrentStart();			    /* Get the start time */
  absoluteEnd = NULL;
  if (absoluteStart == NULL)	
  {
    return;
  }
  absoluteEnd = (Msf) GetCurrentEnd();				    /* Get the end time */
  if (absoluteEnd == NULL) 
  {
    return;
  }
  if (CheckSelection(absoluteStart, absoluteEnd) == Error)	    /* Check that the time is valid */
  {
    return;
  }
  duration = xv_get(cdEdit_PreviewPopup->PreviewTimeText,	    /* Get the duration that the preview is to be played */
		    PANEL_VALUE);
  startMsf = (Msf) malloc(sizeof(struct msf));			    /* Set the start time based on the duration */
  startMsf->min = absoluteEnd->min;
  startMsf->sec = absoluteEnd->sec - duration;
  startMsf->frame = absoluteEnd->frame;
  while (startMsf->sec < 0)
  {
    startMsf->sec +=60;
    startMsf->min--;
  }
  if (CompareMsf(startMsf, absoluteStart) == Less) 
  {
    startMsf = absoluteStart;
  }
  msf.cdmsf_min0 = startMsf->min;				    /* Set the time limits to play from/to */
  msf.cdmsf_sec0 = startMsf->sec;
  msf.cdmsf_frame0 = startMsf->frame;
  msf.cdmsf_min1 = absoluteEnd->min;
  msf.cdmsf_sec1 = absoluteEnd->sec;
  msf.cdmsf_frame1 = absoluteEnd->frame;
  playerState = PlayMode;
  cdrom_play_msf(fd, msf);
  free (startMsf);
  
}

/*
 * Notify callback function for `ClosePreviewPopupButton'.
 * Close the preview popup window.
 */
void PreviewDone(item, event)
     Panel_item	item;
     Event		*event;
{
  xv_set(cdEdit_PreviewPopup->PreviewPopup, FRAME_CMD_PUSHPIN_IN, FALSE, NULL);
  xv_set(cdEdit_PreviewPopup->PreviewPopup, XV_SHOW, FALSE, NULL);
}
