/* m3ddelay.c  --  calculate delay between input and corresponding output */

/* contains: CalcDelay() */

/* dependencies: none */

/* morph3d version 4.0   1 June 1993               */
/* 3D image morphology program                     */
/*                                                 */
/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */
/* Nashville, TN 37235                             */
/* rap2@vuse.vanderbilt.edu                        */
/*                                                 */
/* This software is freely redistributable if      */
/* the author's name and affiliation are included. */


#include "morph3d.h"

/* calculate delay between input and corresponding output */

int CalcDelay( MorphOp, sZ, sorgz )
   int MorphOp;
   int sZ;
   int sorgz;
   {
   switch ( MorphOp & OPMASK )
      {
      case ERODE  :
      case RANK   :
      case LUM    :
      case LUMSMO :
      case LUMSHA :
      case MAXMIN :
      case MINMAX :
         return(sZ - sorgz - 1);
      case DILATE :
         return(sorgz);
      case OPEN  :
      case CLOSE :
         return(sZ-1);
      /* this error should never occur */
      default:
         fprintf(stderr,
         "CalcDelay: The flurby map has overwritten the lamoid pointer!\n");
         exit(0);
      }
   }
