/* andimg -- program to form a logical AND of two rasterfile images */
/* version 1.1     18 Aug 1990 */

/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */ 
/* Nashville, TN 37235                             */ 
/* rap2@vuse.vanderbilt.edu                        */ 
/*                                                 */ 
/* This software is freely redistributable if      */ 
/* the author's name and affiliation are included. */


#include <math.h>		
#include <stdio.h>
#include <strings.h>
#include <values.h>
#include "rasterio.h"
#include "andimg.h"

#define ALLOC 1


main( argc, argv ) 
   unsigned int argc;    /* count of arguments parsed by operating system    */
   char *argv[];         /* pointers to arguments parsed by operating system */
   {
   FILE *fp;                /* file pointer */
   struct rasterfile H1,H2; /* rasterfile headers */
   byte *cmap1,*cmap2;      /* colormaps */
   byte *I1,*I2,*I3;        /* image pointers */
   byte *u,*v,*z;           /* image pointers */
   int X,Y;                 /* image dimensions */
   int i,j,k;               /* indices */


   if (argc < 4)
      {
      fprintf(stderr,
         "usage: andimg rasimg1 rasimg2 outrasimg\n");
      exit(0);
      }


   /* open input file 1 */
   fp = OpenFile( argv[1], "IMGPATHI", "r" );
   if (  ReadRasterFile( fp, &H1, &cmap1, &I1, 0, 0, 0, 0, ALLOC )  ) exit( 0 );
   fclose( fp );


   /* remap the image */
   ExtractLuminance( &H1, cmap1, I1, 0, 0, 0, 0 );


   /* image dimensions */
   X = H1.ras_width;
   Y = H1.ras_height;


   /* open file 2 */
   fp = OpenFile( argv[2], "IMGPATHI", "r" );
   if (  ReadRasterFile( fp, &H2, &cmap2, &I2, 0, 0, 0, 0, ALLOC )  ) exit( 0 );
   fclose( fp );


   /* check dimensions */
   if ( (H2.ras_width != X)  ||  (H2.ras_height != Y) )
      {
      fprintf(stderr, "The two input images have unequal dimensions\n");
      exit( 0 );
      }


   /* remap the image */
   ExtractLuminance( &H2, cmap2, I2, 0, 0, 0, 0 );


   /* make output image. */
   if ( !(I3 = (byte *)calloc( X*Y, sizeof(byte) )) )
         {
         fprintf(stderr, "Unable to allocate output image buffer.");
         exit( 0 );
         }


   /* do the AND */
   u = I1;
   v = I2;
   z = I3;
   for ( j=0; j<Y; ++j )
      for ( i=0; i<X; ++i)
         {
         *z = *v ? *u : 0;
         ++z;
         ++u;
         ++v;
         }

        
   /* create output file */
   fp = OpenFile( argv[3], "IMGPATHO", "w" );

   WriteRasterFile( fp, &H1, cmap1, I3, 0, 0, 0, 0 ); 
               
   fclose( fp );
   free( I1 );
   free( I2 );
   free( I3 );
   if ( cmap1 ) free( cmap1 );
   if ( cmap2 ) free( cmap2 );

   }
