/* include file for linco.c  (linear combination of rasterfile images) */
/* version 1.1 21 Aug 1990  */

/* by Richard Alan Peters II                       */
/* Department of Electrical Engineering            */
/* Vanderbilt University School of Engineering     */ 
/* Nashville, TN 37235                             */ 
/* rap2@vuse.vanderbilt.edu                        */ 
/*                                                 */ 
/* This software is freely redistributable if      */ 
/* the author's name and affiliation are included. */

/* This program makes a linear combination of two (rasterfile) images:        */
/* ImgOut = a * Img1 + b * Img2.  It will also multiply one image by a        */
/* constant and add a scalar if a second image is not specified. That is,     */
/* if the second image is not specified, the identity image, I, (image of all */
/* ones) is assumed: ImgOut = a * Img1 + b * I.  All operations are pointwise */
/* (pixel-to-pixel). Internal calculations are performed in floating-point.   */
/* The output is a byte image. The scaling options are described below.       */
/* If instead of a second rasterfile input image the word "nonzero" is        */
/* specified, a*Img1+b is performed only on nonzero pixels. This is useful    */
/* for operations on masks or edgemaps.                                       */

/* The user can specify six types of scaling. (let max be the largest gray-   */
/* level and min the smallest gray-level in the resultant linear combination. */

/* (1) default: no scaling, the resultant image is clipped at BLACK and WHITE */

/* (2) switch -c: compression scaling, if the dynamic range (max-min+1) of    */
/* the resultant image is > 256 the pixels are compressed an translated       */
/* (a 1-dim affine transform) to take on values between BLACK and WHITE       */
/* However, if the dynamic range is <= 256 (less than or equal to 256) one of */
/* the three following operations is performed: If max <= WHITE and           */
/* min >= BLACK, no scaling is performed. If max > WHITE then all the pixels  */
/* are translated so that max == WHITE. If min < BLACK, then all the pixels   */
/* are translated so that min == BLACK.                                       */

/* (3) switch -f: forced scaling, i.e. compression or expansion scaling. All  */
/* pixels are put through a 1-dim affine transform so that min == BLACK and   */
/* max == WHITE.                                                              */

/* (4) switch -u: translation up, a constant is added to each pixel so that   */
/* the image maximum is WHITE. It is clipped from below at BLACK.             */

/* (5) switch -d: translation down, a constant is added to each pixel so that */
/* the image minimum is BLACK. It is clipped from above at WHITE.             */

/* (6) switch -a: affine transform specified by arguments slope and intercept */
/* each pixel is trasformed by pixel_out = slope*pixel + intercept.           */

/* Switch -b tells linco to take the absolute value of the linear combination */
/* prior to scaling.                                                          */

/* notes:  .all arithmetic is floating point                                  */
/*         .arguments a and b may be either real or integer                   */
/*         .no scaling is performed if none of -a, -c, -d, -f, or -u are      */
/*          specified                                                         */
/*         .scaling is not necessary if a and b are such that a + b = 1.0     */


/* usage: linco a rasimg1 b [rasimg2|nonzero] -o outimg [-c | -f | -u | -d |  */
/*             -a slope intercept]  -b                                        */

#define MIN(a,b) ((a)<(b)?(a):(b))
#define MAX(a,b) ((a)>(b)?(a):(b))

#define TRUE 1
#define FALSE 0
#define BLACK 0
#define WHITE 255


extern FILE *OpenFile();

#ifndef BYTE
typedef unsigned char byte;
#define BYTE 1
#endif

