/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

/*********************************************************************
  Creates MPEGTool Progress dialog, which shows state of encode
  in each frame. With FREQUENT_UPDATE option, update will be made in
  each slice. This dialog also has terminate bottun, which terminate
  encoder and return MPEGTool encoder dialog if pushed.
 *********************************************************************/
#include <Xm/DialogS.h>
#include <Xm/MessageB.h>
#include <Xm/PushB.h>
#include <X11/cursorfont.h>
#include <malloc.h>
#include <stdio.h>
#include "global.h"
#include "errorhandle.h"

void error_popup();
void TimeoutCursors();
Widget GetTopShell();

/*--- globals for control working dialog ---*/
static int stopped;
static Widget working_dlg;
static Widget parent;
/*------------------------------------------*/
void
  encoder_pushed(w, P) /* execute mpeg encoder */
Widget w;
MPEG_param *P;
{
  Display *dpy;

  parent = GetTopShell(w);
  if (Xon) {
    stopped = False;
    /*--- create working dialog ---*/
    TimeoutCursors(True,P->num_of_frame);
    /*--- initialize injterupt routine ---*/
    if(mpeg_encoder_param_set(P)) {
      TimeoutCursors(False,0);/* destroy working dlg */
      error_popup(w);
      return;
    }
    else {
      TimeoutCursors(False,P->num_of_frame);
      return;
    }
  }
  else {
    mpeg_encoder_param_set(P);
    return;
  }
  
}

int
  working_update(mode, label_txt, max_count)
int mode; /* 0: interrupt check only, 1: title, 2: message */
char* label_txt;
int max_count;
{
  static char base_str[126];
  static int count;
  static int total_num;
  static int frame_num;
  static  char new_txt[126];
  Display *dpy;
  Window win;
  XEvent event;
  XmString str;
  /*------ process for parent ------*/
  dpy = XtDisplay(parent);
  XFlush(dpy);
  XmUpdateDisplay(parent);
  /*------ buffered process ------*/
  win = XtWindow(working_dlg);
  while (XCheckMaskEvent(dpy,
            ButtonPressMask | ButtonReleaseMask | ButtonMotionMask |
            PointerMotionMask | KeyPressMask | KeyReleaseMask,
            &event)) {
    if(event.xany.window == win)
      XtDispatchEvent(&event);
  }
  if(mode == 0) return(stopped);
#ifdef NO_PROGRESS
  return stopped;
#endif
  if(!XtIsManaged(working_dlg))  XtManageChild(working_dlg);
  if(mode == 1) {
    /*------ update message in working dlg ------*/
    if(label_txt != NULL) {
      if(max_count>0) {
        count = 0; /* reset conuter */
#ifdef FREQUENT_UPDATE
        sprintf(base_str,"%s (%%d/%d)",label_txt, max_count);
#else
        strcpy(base_str,label_txt);
#endif
      }
      else { /* count = 0, no update info */
        strcpy(base_str,label_txt);
      }
      sprintf(new_txt, base_str, count);
      str = XmStringCreateSimple(new_txt);
      XtVaSetValues(working_dlg,
        XmNmessageString, str,
        NULL);
      XmStringFree(str);
    }
#ifdef FREQUENT_UPDATE
    else { /* label_txt == NULL */
      count ++;
    }
    sprintf(new_txt, base_str, count);
    str = XmStringCreateSimple(new_txt);
    XtVaSetValues(working_dlg,
      XmNmessageString, str,
      NULL);
    XmStringFree(str);
#endif
  }
  /*------ update title in working dlg ------*/
  else { /* mode == 2 */
    if(max_count>0) {  /* to update title, set max_count to 0 */
      total_num = max_count; /* set tital frame number */
      frame_num = 0;         /* reset frame number counter */
    }
    else {
      frame_num++;
    }
    sprintf(new_txt, "MPEGTool: Encode in Progress (%d/%d)",
                      frame_num, total_num);
    XtVaSetValues(XtParent(working_dlg),
      XmNtitle, new_txt,
      NULL);
  }
  XmUpdateDisplay(working_dlg);
  return stopped;
}

void
  TimeoutCursors(on, frame_num)
int on; /* 1 : working dialog on. 0: destroy working dialog */
int frame_num; /* number of frame to enccode */
{
  static int locked;
  static Cursor cursor;
  char title_str[256];
  XSetWindowAttributes attrs;
  Display *dpy = XtDisplay(parent);
  XEvent event;
  XmString stop_str, msg_str;

  extern void stop();
  extern void quit_dialog();

  on ? locked++ : locked--;
  if(locked > 1 || locked == 1 && on == 0) return;
  if(!cursor) cursor = XCreateFontCursor(dpy, XC_watch);
  attrs.cursor = on ? cursor : None;

  XChangeWindowAttributes(dpy, XtWindow(parent), CWCursor, &attrs);
  XFlush(dpy);

  if(on) {
    stop_str = XmStringCreateSimple("Terminate");
    msg_str = XmStringCreateSimple(
     "                                                  ");/* 50 blanks */
    working_dlg = XmCreateWorkingDialog(parent, "working", NULL, 0);

    XtVaSetValues(working_dlg,
      XmNcancelLabelString, stop_str,
      XmNmessageString,     msg_str,
      XmNdialogStyle,       XmDIALOG_FULL_APPLICATION_MODAL,
      NULL);

    XmStringFree(stop_str);
    XmStringFree(msg_str);

    sprintf(title_str, "MPEGTool: Encode in Progress (0/%d)", frame_num);
    XtVaSetValues(XtParent(working_dlg),
      XmNtitle, title_str,
      XmNmaxWidth, 361,
      XmNminWidth, 361,
      XmNmaxHeight, 113,
      XmNminHeight, 113,
      NULL);

    XtAddCallback(working_dlg, XmNcancelCallback, stop, NULL);

    XtUnmanageChild(XmMessageBoxGetChild(working_dlg, XmDIALOG_OK_BUTTON));
    XtUnmanageChild(XmMessageBoxGetChild(working_dlg, XmDIALOG_HELP_BUTTON));
  }
  else {
    if(frame_num == 0) {
      XtPopdown(XtParent(working_dlg));
      XtDestroyWidget(working_dlg);
      return;
    }
    while (XCheckMaskEvent(dpy,
             ButtonPressMask | ButtonReleaseMask | ButtonMotionMask
             | PointerMotionMask | KeyPressMask, &event)) { /* do nothing */ }
    stop_str = XmStringCreateSimple("   OK   ");
    msg_str = XmStringCreateSimple("MPEG Encode Complete !!!");
    XtVaSetValues(working_dlg,
      XmNcancelLabelString, stop_str,
      XmNmessageString,     msg_str,
      XmNdialogType,        XmDIALOG_INFORMATION,
      NULL);

    sprintf(title_str, "MPEG Encoding Complete (%d/%d)",frame_num, frame_num);
    XtVaSetValues(XtParent(working_dlg),
      XmNtitle, title_str,
      NULL);

    XmStringFree(stop_str);
    XmStringFree(msg_str);

    XtRemoveCallback(working_dlg, XmNcancelCallback, stop, NULL);
    XtAddCallback(working_dlg, XmNcancelCallback, quit_dialog, working_dlg);
  }
}

void
  stop(w)
Widget w;
{
  stopped = True; errnum = 30;
}
