/*
 * Copyright 1993 by the University of Pennsylvania
 *
 * Permission to use, copy, and distribute for non-commercial purposes,
 * is hereby granted without fee, providing that the above copyright
 * notice appear in all copies and that both the copyright notice and this
 * permission notice appear in supporting documentation.
 *
 * The software may be modified for your own purposes, but modified versions
 * may not be distributed.
 *
 * This software is provided "as is" without any expressed or implied warranty.
 */

#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include "global.h"
#define INIT_STAT_FNAME "\0"
#define INIT_PS_FNAME "out.ps"
#define PLOTMACRO "plot.gnu" /* gnuplot macro name */
#define PLOTDATA  "plot.dat" /* gnuplot data name */

/********************* DISPLAY paramter ******************/
void
  disp_stat_param(S)
STAT_param *S;
{
  char *menu ="\n\
************************************************\n\
*  (1) level           : %5d                 *\n\
*  (2) atm mode        : %5d                 *\n\
*  (3) scope           : %5d                 *\n\
*  (4) priority        : %5d                 *\n\
*  (5) kind_of_stat    : %5d                 *\n\
*  (6) start frame     : %5d                 *\n\
*  (7) num of frame    : %5d                 *\n\
*  (8) ps out          : %5d                 *\n\
*  (9) stat_file_name  : %-20s  *\n\
* (10) ps_file_name    : %-20s  *\n\
* (10) plot_macro_name : %-20s  *\n\
* (10) plot_data_name  : %-20s  *\n\
************************************************\n";
  printf(menu,S->level,
              S->atm_mode,
              S->scope,
              S->priority,
              S->kind_of_stat,
              S->start_frame,
              S->stat_num,
              S->ps_out,
              S->stat_file_name,
              S->ps_file_name,
              S->plot_macro_name,
              S->plot_data_name);
}
/******************** Set initial value for parameter ******************/
STAT_param *
  init_stat_param()
{
  STAT_param *S;
  S = (STAT_param*)malloc(sizeof(STAT_param));
  S->level = 0;  /* 0:bit/frm, 1:bit/slc, 2:bit/MB, 3:ATM/frm, 4: ATM/slc */
  S->atm_mode     = 0;  /* 0: bit, 1: ATM packet mode (44 byte/packet) */
  S->scope        = 0;  /* 0: frame, 1: slice, 2: macro block */
  S->priority     = 1;  /* 0: both, 1: HP, 2: LP, 3:HP+LP */
  S->kind_of_stat = 1;  /* 0: distribution,    1: generation record, 
                          2: autocorrelation, 3: interarrival time */
  S->start_frame  = 1;  /* satrt frame # to make statistics */
  S->stat_num     = 5;/* item # to make statistics */
  S->ps_out       = 0;  /* 0: no ps out, 1: generate ps file of graph */
  strcpy(S->stat_file_name,INIT_STAT_FNAME);
  strcpy(S->ps_file_name,INIT_PS_FNAME);
  strcpy(S->plot_macro_name, PLOTMACRO);
  strcpy(S->plot_data_name, PLOTDATA);
  return S;
}

