/*
  File: crc.hh

  */

#ifndef __crc_hh__
#define __crc_hh__

// 16-Bit CRC checksum class:

class Crc16 {
  static const uint16 polynomial;
  uint16 crc;
 public:
  Crc16 (void){ crc = 0xFFFF; }
  void add_bits(uint32 bitstring, uint32 length);
  // feed a bitstring to the crc calculation (0 < length <= 32)
  uint16 checksum (void){
    // return the calculated checksum and erase it for next calls to add_bits()
    register uint16 sum = crc;
    crc = 0xFFFF;
    return sum;
  }
};

#endif
