/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"

#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3, c4;
PR_nurb s1, s2, s3, s4;
Ppoint3 pt;

Pint ee,ii,nsteps,i,j,npt;
Pfloat tpts[100];

Pfloat dt,t1,t2,tol;
Pmatrix3 xx;
PR_dir  tnew= {0};
FILE *fp;

void putpoint3(C(FILE *)fp, C(Ppoint3)xx)
PreANSI(FILE *fp)
PreANSI(Ppoint3 xx)
{
fprintf(fp,"%12.4g%12.4g%12.4g",xx.x,xx.y,xx.z);
}

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);
  nrb_clear(&c2);
  nrb_clear(&c3);
  nrb_clear(&c4);

  nrb_clear(&s1);
  nrb_clear(&s2);
  nrb_clear(&s3);
  nrb_clear(&s4);

  LINE;
  tol = 0.05;

  fp =fopen("pts.dat","r");

  while (fscanf(fp,"%d",&npt)>0){
    nrb_init(4,npt+4,0,1,&s1);
    nrb_makeknots(0.0,1.0,&s1.pf_u);
    nrb_makeknots(0.0,1.0,&s1.pf_v);
    nrb_allocatepts(npt,&s1.pf_ppp);

    for (i=1; i<=npt;i++){
#ifdef __TURBOC__
      fscanf(fp,"%g%g%g",&pt.x,&pt.y,&pt.z);
#else
      fscanf(fp,"%f%f%f",&pt.x,&pt.y,&pt.z);
#endif
      s1.pf_ppp->pts[i-1] = ptk_pt3topt4(&pt);
      tpts[i] = (i-1)/(npt-1);
    }
    LINE;
    printf("Dump before nrb_interpolate\n");
    nrb_dump(stdout,&s1);
    nrb_interpolate(&s1,tol,&s2);
    LINE;
    printf("Dump after nrb_interpolate\n");
    nrb_dump(stdout,&s2);
    LINE;
    printf("Dump after nrb_spli2d\n");
    nrb_spli2d(&s1,3,tpts,&s3);
    nrb_dump(stdout,&s3);

  }


  LINE;
  nrb_stats(stdout);
  nrb_dumplists(stdout);

  printf("End of NURBs test.\n");
  return 0;
}

/* End. */

