/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : ORTToImage
Version: 1.0
Written on   :  5-Apr-92     By : A. Etemadi
Modified on  : 
Directory    : ~atae/ORT/FEX/exe

==============================================================================


Usage:	
	ORTToImage -r <No. of Rows=Cols> max 512
			-b <Background Intensity>
		      	-l <Intensity> <LineThickness> <EndPointIntensity>
		      	-c <Intensity> <LineThickness> <EndPointIntensity>
		      	-m <MinLength>
			-L Line segments Only
			-C Curved Segments Only
                    	 < <ORT line ASCII data file> > ImageFile

Where
 The  image outputted is square of side "Size" pixels
 and intensity is the value given to the line pixels in the image

Output result       : 

   0 = successful, 
  -1 = error, 

Functionality: 

This program converts ORT lines to a  image

----------------------------------------------------------------------------*/

#include "FEX.h"
#include "LPEG.h"
#include "ListeMacros.h"
#include "Liste.h"

main(argc,argv)

 int  argc;
 char **argv;

{

/*
=======================================================================
===================== START OF DECLARATION ============================
=======================================================================
*/
 int i,j;			/* Loop indecies */
 int Next;

 FILE *p_InFile;		/* Pointers to start of files fo I/O */
 FILE *p_OutFile;

/* 
 Create buffer for image
*/
 char Image [512][512];

/*
 Parameters associated with images
*/

 int WritePGM;
 int Size;
 int OutPutStatus;
 int Background;
 int LineIntensity;
 int LineEndPointIntensity;
 int LineThickness;
 int ArcIntensity;
 int ArcEndPointIntensity;
 int ArcThickness;

/*
 Liste data
*/
 int  N_ListORTLine;
 long Line;
 Liste ID_ListORTLine;
 struct ORTLine        	*ListORTLine;

 int N_ListORTCircularArc;
 long Arc;
 Liste ID_ListORTCircularArc;
 struct ORTCircularArc 	*ListORTCircularArc;

/*
 Other parameters
*/

 int CurveCounter;
 int RadiusSquared;

 double MinLength;
 double r1,r2,r3;

 double junkf,side;
 double x1,x2,x3,x4,y1,y2,y3,y4;
 double Center;

 char text;
/*
=======================================================================
===================== START OF INITIALISATION =========================
=======================================================================
*/
 
/*
 Set defaults, process command line options, and initialise lists

*/

  Next = 0;
  OutPutStatus  		= -1; 
  Background 			= 0;
  LineIntensity 		= 255;
  LineThickness 		= 1;
  LineEndPointIntensity	= 128;
  ArcIntensity 		= 255;
  ArcThickness 		= 2;
  ArcEndPointIntensity	= 128;
  MinLength  			= 3.0;
  WritePGM 			= TRUE;
  
  for (i=1;i<argc;i++) {
       if (argv[i][0] == '-') {
           switch (argv[i][1]) {
           case 'L': Next++ ;  OutPutStatus = 0    ; continue;
           case 'C': Next++ ;  OutPutStatus = 1    ; continue;
           case 'r': Next++;   WritePGM   = FALSE  ; continue;
           case 'b': Next+=2;  Background = (atoi(argv[++i])); continue;
           case 'l': Next+=4;  
			LineIntensity 	= (atoi(argv[++i])); 
			LineThickness 	= (atoi(argv[++i])); 
			LineEndPointIntensity= (atoi(argv[++i])); continue;
           case 'c': Next+=4;  
			ArcIntensity 		= (atoi(argv[++i])); 
			ArcThickness 		= (atoi(argv[++i])); 
			ArcEndPointIntensity	= (atoi(argv[++i])); continue;
           case 'm': Next+=2;  MinLength  = ((double)atof(argv[++i])); continue;
	    case 'V': Next++; fprintf(stderr,"ORTToImage: Version 1.0\n"); return(-1);
	    default : fprintf(stderr,"Error: unrecognized option: %s \n",argv[i]); return(-1);
	    case 'h':
 		fprintf(stderr,"USAGE :\n");
		fprintf(stderr,"    ORTToImage [-hLCrblcm] < InFile > OutFile\n\n");
		fprintf(stderr,"OPTION:\n");
		fprintf(stderr,"-L Line segments only(default all)\n");
		fprintf(stderr,"-C Arc segments only (default all)\n");
		fprintf(stderr,"-r for raw image \n");
		fprintf(stderr,"-b <Background intensity> (max 255, default 255)\n");
		fprintf(stderr,"-l <Intensity Thickness EndpointIntensity> for Lines (default 0 1 128)\n");
		fprintf(stderr,"-c <Intensity Thickness EndpointIntensity> for Arcs (default 0 2 128)\n");
		fprintf(stderr,"-m <Minimum length of segment> (default 5.0)\n\n");
		fprintf(stderr,"WHERE:\n");
		fprintf(stderr,"     InFile should contain ASCII lists of line segments produced by FEX\n");
		fprintf(stderr,"     OutFile will contain PGM formatted image\n");
		return(-1);
	}
    }
  }

/*
 Use standard input/output
*/
       p_InFile  = stdin;
       p_OutFile = stdout;

/*
 Get image size from data header
*/
     text = getc(p_InFile);
     fscanf(p_InFile,"%d",&Size);
     Center = (double) (Size/2);
     LineThickness--;
     ArcThickness--;

/*
  Set image pixels to background value
*/
  for (i=0;i<Size;i++) {
      for (j=0;j<Size;j++) {
 	    Image[i][j] = (char) Background;
	}
  }

if (OutPutStatus == -1 || OutPutStatus == 0) {

/*
 Read the ORT line data and draw the line on the image
*/

CrtORTLineList( &p_InFile,
   	 	  MinLength,
                &ListORTLine,
                &ID_ListORTLine,
		  &N_ListORTLine);

for (i=1 ; i<=N_ListORTLine; i++ ) {

  Line = ElmNumList ( ID_ListORTLine, (long)i);
  ListORTLine = MACCast(ORTLine,Line);

  DrawBezierLine ( (int) (ListORTLine->Start.Col + Center), 
                   (int) (ListORTLine->Start.Row + Center), 
                   (int) (ListORTLine->End.Col   + Center), 
                   (int) (ListORTLine->End.Row   + Center), 
		     LineIntensity, LineThickness, LineEndPointIntensity, 
		     Size, Image);
 }

} /* endif OutPutStatus */

if (OutPutStatus == -1 || OutPutStatus == 1) {

/*
 Read the ORT Curve data and draw the Curve on the image
*/

CrtORTCircularArcList( &p_InFile,
               	  &ListORTCircularArc,
                       &ID_ListORTCircularArc,
			  &N_ListORTCircularArc);

for (i=1 ; i<=N_ListORTCircularArc; i++ ) {

  Arc = ElmNumList ( ID_ListORTCircularArc, (long)i);
  ListORTCircularArc = MACCast(ORTCircularArc,Arc);

 if ( ListORTCircularArc->Length >= MinLength) {

  x1 = ( ListORTCircularArc->Start.Col    + Center); 
  y1 = ( ListORTCircularArc->Start.Row    + Center); 
  x2 = ( ListORTCircularArc->MidPoint.Col + Center); 
  y2 = ( ListORTCircularArc->MidPoint.Row + Center); 
  x3 = ( ListORTCircularArc->End.Col      + Center); 
  y3 = ( ListORTCircularArc->End.Row      + Center); 
  x4 = ( ListORTCircularArc->Origin.Col   + Center); 
  y4 = ( ListORTCircularArc->Origin.Row   + Center); 

  RadiusSquared = (int) (ListORTCircularArc->Radius *  ListORTCircularArc->Radius); 

  DrawCircularArc  ( ((int)x1),((int)y1),
			((int)x3),((int)y3),
			((int)x4),((int)y4),
			ListORTCircularArc->Direction,    /* -1 clockwise 1 counterclockwise */
			RadiusSquared,
 			ArcIntensity, ArcThickness, ArcEndPointIntensity, 
			Size, Image);

  }

 }

} /* endif OutPutStatus */

/*
  Output the image data
*/

  if (WritePGM == TRUE)
	fprintf(p_OutFile,"P5\n%d %d\n255\n",Size,Size);

  for (i=0;i<Size;i++) {
      for (j=0;j<Size;j++) {
	   putc(Image[i][j],p_OutFile);
	}
  }

/*
 Close all files
*/
         fclose(p_InFile);
         fclose(p_OutFile);

	  return(0);
}
