#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

int DrawBezierLine ( x1, y1, x2, y2, 
			LineIntensity, LineThickness,
			EndPointIntensity,
			size, Image)

	int x1,x2,y1,y2;
	int LineIntensity;
	int LineThickness;
	int EndPointIntensity;
	int size;
	char Image[512][512];
{
	int temp, deltax, deltay, xincrement, yincrement, e, a, b, i;
       int k,l;

              for(k =(x1-1); k<=(x1+1); k++){
               for(l =(y1-1); l<=(y1+1); l++){
		  if (l <= size && k <= size && l >= 0 && k >= 0) {
	          	Image[l][k] = (EndPointIntensity & 0377);
                }
               }
              }

              for(k =(x2-1); k<=(x2+1); k++){
               for(l =(y2-1); l<=(y2+1); l++){
		  if (l <= size && k <= size && l >= 0 && k >= 0) {
	          	Image[l][k] = (EndPointIntensity & 0377);
                }
               }
              }

if (abs(x2-x1) > abs(y2-y1)) {
   if (x1 > x2) {
      temp = x1; x1 = x2; x2 = temp;
      temp = y1; y1 = y2; y2 = temp;
   }
   deltax = x2 - x1;
   deltay = abs (y2 - y1);
   e = (2 * deltay) - deltax;
   a = (2 * deltay) - (2 * deltax);
   b = (2 * deltay);
   if (y2 > y1) { 
	yincrement = 1;
   } else {
	yincrement = -1;
   }
   for (i= 0;i<=deltax;i++) {

      if ((x1>0) && (x1<=size) && (y1>0) && (y1<=size)) {
             for(k =(x1-LineThickness); k<=(x1+LineThickness); k++){
               for(l =(y1-LineThickness); l<=(y1+LineThickness); l++){
	          	Image[l][k] = (LineIntensity & 0377);
               }
             }
      }
      if (e > 0) {
         y1 = y1 + yincrement;
         e = e + a;
      } else {
         e = e + b;
      }
         x1 = x1 + 1;
   }
} else {
   if (y1 > y2) {
      temp = x1; x1 = x2; x2 = temp;
      temp = y1; y1 = y2; y2 = temp;
   }
   deltay = y2 - y1;
   deltax = abs(x2 - x1);
   e = (2 * deltax) - deltay;
   a = (2 * deltax) - (2 * deltay);
   b = (2 * deltax);
   if (x2 > x1) {
	xincrement = 1; 
   } else {
	xincrement = -1;
   }
   for (i= 0;i<=deltay;i++) {

      if ((x1>0) && (x1<=size) && (y1>0) && (y1<=size)) {
              for(k =(x1-LineThickness); k<=(x1+LineThickness); k++){
               for(l =(y1-LineThickness); l<=(y1+LineThickness); l++){
	          	Image[l][k] = (LineIntensity & 0377);
               }
             }
      }
      if (e > 0) {
         x1 = x1 + xincrement;
         e = e + a;
      } else {
         e = e + b;
      }
      	  y1 = y1 + 1;
   }
 }
	return(0);
}
