/* FILE:   fill.h
 
   Prototypes for routines for filling are are here.

   Written by Petri Kuittinen, last modifications 25th August 1993.
*/

struct poly_edge
{
  int x1; int y1; /* coordinates of the upper edge end point */
  int x2; int y2; /* coordinates of the lower edge end point */
  int d;          /* delta */
  int ax;         /* x2-x1 */
  int sx;         /* sign of x2-x1 */
  int dy;         /* number of vertical lines (maybe smaller than y2-y1) */
};

/* Polygon */
struct polygon
{
  struct poly_edge *edge_list; /* pointer to edge list */
  int n_edges;                 /* number of edges (0=empty polygon) */
  int min_x;                   /* smallest x value in polygon edge */
  int min_y;                   /* smallest y value in polygon edge */
  int max_x;                   /* largest x value in polygon edge */
  int max_y;                   /* largest y value in polygon edge */
};

/* Protypes */
struct polygon *create_polygon();
void add_polygon_edge (struct polygon *poly, int x1, int y1, int x2, int y2);
void delete_polygon(struct polygon *poly);
void fill_polygon (struct polygon *poly, void (*put_pixel) (int x, int y));
