/* vector_names.h - preprocessor macros for vector class template
 *
 * $Id: vector_names.h,v 1.1 92/04/27 04:25:14 leech Exp $
 *
 * Copyright (C) 1992, Jonathan P. Leech
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is". Bug reports or fixes may be sent
 * to the author, who may or may not act on them as he desires.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 * $Log:	vector_names.h,v $
 * Revision 1.1  92/04/27  04:25:14  leech
 * Initial revision
 * 
 */

#ifndef _VECTOR_NAMES_H
#define _VECTOR_NAMES_H

#include <generic.h>

// Conversions between degrees and radians
inline float dtor(float deg) {
    return deg * M_PI / 180.0;
}

inline float rtod(float rad) {
    return rad * 180.0 / M_PI;
}

// Pointer to error handler method for a class
typedef void (*errorHandler)(int, const char *);

// Names of matrix/vector types parameterized with the preprocessor (ick)
#define CVec(T) name2(T,CVec)	/* Cartesian vector of type T */
#define HVec(T) name2(T,HVec)	/* Homogenous vector of type T */

#define CMat(T) name2(T,CMat)	/* Cartesian (affine) matrix of type T */
#define CMatType(T) name2(T,CMatType)

#define HMat(T) name2(T,HMat)	/* Homogenous (4x4) matrix of type T */
#define HMatType(T) name2(T,HMatType)

#endif /*_VECTOR_NAMES_H*/
