/*
 File: Shuffle.c
 Authors: K.R. Sloan
 Last Modified: 26 October 1992
 Purpose: reads a polygon and creates all possible variations
          *all rotations
          *both directions
          *all 8 orientations!
 */
#include <stdio.h>

static int VERBOSE = 0;
static char *RoutineName;
static void usage()
 {
  fprintf(stderr,"Usage is\n\t%s [-h][-v] -f filename-prefix\n",
               RoutineName);
 }

static void FatalError(s)
 char *s;
 {
  fprintf(stderr,"%s: FatalError(%s)\n",RoutineName,s);
  exit(-1);
 }

typedef struct Point { double x, y; } Point;
#define Size (64)
Point Points[Size];
int LastPoint;

char *Prefix;


static int ReadPoints(s,P)
 FILE *s;
 Point P[];
 {
  int i;

  for(i=0;i<Size;i++)
   if (2 != fscanf(s," %lf %lf", &(P[i].x), &(P[i].y)))
    return i;

 }

static void WritePoints(P,n,O,dir,x,y,xy,Prefix)
 Point P[];
 int n,O,dir,x,y,xy;
 char *Prefix;
 {
  char FileName[128];
  char D,X,Y;
  FILE *s;
  int i,j;
  double Px,Py,t;
  char tc;

  if (1 == dir) D  = 'F'; else D  = 'B';
  if (1 == x  ) X  = 'X'; else X  = 'x';
  if (1 == y  ) Y  = 'Y'; else Y  = 'y';
  if (1 == xy ) {tc = X; X = Y; Y = tc;}
  sprintf(FileName,"%s.%d.%c%c%c",Prefix,O,D,X,Y);
  s = fopen(FileName,"w");
  if ((FILE *)0 == s) FatalError("opening output file");

  for(i=0,j=O;i<n;i++,j = (j+dir+n)%n)
   {
    Px = P[j].x; Py = P[j].y;
    if (1 == x ) Px = -Px;
    if (1 == y ) Py = -Py;
    if (1 == xy) { t = Px; Px = Py; Py = t; }
    fprintf(s,"%lf %lf\n",Px,Py);
   }
  if (fclose(s)) FatalError("closing output file");
 }

static void Shuffle(P,n,Prefix)
 Point P[];
 int n;
 char *Prefix;
 {
  int i;
  int x,y,xy;

  for(xy=0;xy<2;xy++)
   for(x=0;x<2;x++)
    for(y=0;y<2;y++)
     {
      for(i=0;i<n;i++)
       WritePoints(P,n,i,1,x,y,xy,Prefix);
      for(i=0;i<n;i++)
       WritePoints(P,n,n-1-i,-1,x,y,xy,Prefix);
     }
 }

int main (argc, argv)
 int argc;
 char *argv[];
 {
  int ArgsParsed=0;

  RoutineName = argv[ArgsParsed++];

  Prefix = (char *)0;
  while (ArgsParsed < argc)
   {
    if ('-' == argv[ArgsParsed][0])
     switch (argv[ArgsParsed++][1])
      {
       case 'f': if (ArgsParsed >= argc) {usage(); exit(-1);}
                 Prefix = argv[ArgsParsed++];
                 break;
       case 'v': VERBOSE  = -1; break;
       default:
       case 'h': usage(); exit(-1);
      }
   }

  if ((char *)0 == Prefix) {usage(); exit(-1);}

  LastPoint = ReadPoints(stdin,Points);

  Shuffle(Points,LastPoint,Prefix);

  exit(0);
}
