/* file: tests.c - all routines to test */

#include "stdio.h"
#include "math.h"
#include "perf.h"

/*****************************************************************************/
/* these routines are for faking out other routines which read data using
 * an input stream, instead of using the 'pVert' array
 */
static	int	nStreamVert, onStreamVert;
static	Number	(*pStreamVert2D)[2];		/* ptr to 2D table */

setUpFakeScanf2D( nvert, pVert )
int	nvert;
Number	pVert[][2];
{
    nStreamVert = nvert;
    pStreamVert2D = pVert;
    onStreamVert = 0;
}

perf_feof()
{
    if ( onStreamVert >= nStreamVert ) return( 1 );
    return(0);
}

perf_fscanf( pfile, fmt, pnumx, pnumy )
FILE    *pfile;
char    *fmt;
Number  *pnumx;
Number  *pnumy;
/* for routines which insists on reading from a data stream */
{
    if ( onStreamVert >= nStreamVert ) return( 0 );
    *pnumx = pStreamVert2D[ onStreamVert ][0];
    *pnumy = pStreamVert2D[ onStreamVert ][1];
    onStreamVert++;
    return(2);
}

/*****************************************************************************/
#define X       0
#define Y       1
#define Z       2
#define W       3

/* return 'z' of left-hand or right-hand cross product */
#define GIScalerCrossZ( v0, v1 ) ( (v0)[X] * (v1)[Y] - (v0)[Y] * (v1)[X] )

/*****************************************************************************/
/*****************************************************************************/
/* Fred Fisher test */

isConvexFred( nvert, pVert )
int	nvert;
Number	pVert[][2];
/* determine shape of polygon. return:
 * ReturnDegenerateConvex    if degenerate (all points co-linear or co-incident)
 * ReturnDegenerateNonConvex if degenerate, but vertices are non-convex
 * ReturnConvex		     if convex and not degenerate
 * ReturnNonConvex	     if non-convex
 * 
 * currently, if 'ReturnNonConvex' is returned, the polygon may be
 * degenerate, or it may not. To fix this you'd have to go through the rest
 * of the points once the "wrong" turn was taken.
 */
{
    int		firsti1, i1, i2, 
		adir = DirUnknown,  nturn = 0, knowOutside = 0;
    Number	vec1[3], vec2[3], *pcur, *pnext, *ptemp, ccw = 0.0, 
		outside = 0.0;

    if ( nvert < 3  ) return( ReturnDegenerateConvex );

    /***** index 0 will be the first point.
     *     find index i1 to the first non-coincident point
     */
    i1 = 1;
    pcur  = vec1;
    pnext = vec2;
    /* scan for first pair of non-coincident pts */
    do {
	/* this is faster than computing entire cross product and checking
	 * for zero. we'll use 'pcur' later to complete cross product.
	 */
	pcur[X] = pVert[i1][X] - pVert[0][X];
	pcur[Y] = pVert[i1][Y] - pVert[0][Y];
	if ( pcur[X] != 0.0  ||  pcur[Y] != 0.0 ) {
	    break;
	}
    } while ( ++i1 < nvert );
    if ( i1 >= nvert ) return( ReturnDegenerateConvex ); /* all coincident */
    firsti1 = i1;			/* remember first non-coincident */

    /***** find the next point that's not coincident with coord 'i1'
     * at first I thought of looking for the next point which does not
     * produce a zero cross product (because of repeated points or movement
     * along the same edge. However, this didn't account for things like:
     * 0 0, 1 0, 0 0, 0 1 where (0 1) would be the next point and give a
     * non-zero cross product.
     */
    i2 = i1;
    while ( ++i2 < nvert ) {
	pnext[X] = pVert[i2][X] - pVert[i1][X];
	pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
	if ( pnext[X] == 0.0  &&  pnext[Y] == 0.0 )
	    continue;
	ccw = GIScalerCrossZ( pcur, pnext );
	/* must get out, consider [0,0] [1,0] [0,0] [0,1] */
	break;
    }
    if ( i2 >= nvert )
	return( ReturnDegenerateConvex ); /* rest of points coincident w/i1 */

    /* check for X coord direction change. sometimes check for Y changing */
#define	CheckNextVertexForDirection(pcur, pnext)			\
    if ( pnext[X] > 0.0 ) {						\
	if ( adir != DirPlus ) {					\
	    nturn++;							\
	}								\
	adir = DirPlus;							\
    } else if ( pnext[X] < 0.0 ) {					\
	if ( adir != DirNeg ) {						\
	    nturn++;							\
	}								\
	adir = DirNeg;							\
    } else if ( pnext[Y] > 0.0 ) {					\
	if ( adir != DirPlus ) {					\
	    nturn++;							\
	}								\
	adir = DirPlus;							\
    } else if ( pnext[Y] < 0.0 ) {					\
	if ( adir != DirNeg ) {						\
	    nturn++;							\
	}								\
	adir = DirNeg;							\
    }

#define	TooManyTurns	( nturn > 2 )

#define	DetermineConvexDirection( crossResult )				\
    if ( crossResult < 0 ) {						\
	knowOutside = 1; outside = -1.0;				\
    } else {								\
	if ( crossResult > 0 ) {					\
	    knowOutside = 1; outside =  1.0; 				\
        }								\
    }									\

#define	TraceResults							\
    GITrace( 7,								\
	printf(								\
"on%2d,%2d xydir/%2d turn/%d know=%d ccw=%g, pcur=[%g,%g] pnext=[%g,%g]\n",\
		i1,i2,  	adir, nturn, knowOutside, ccw,		\
		pcur[X], pcur[Y],      pnext[X], pnext[Y] );		\
    )									\

    /***** we now have 3 non-coincident points, find first direction */
    if ( pcur[X] > 0.0 )      adir = DirPlus;
    else if ( pcur[X] < 0.0 ) adir = DirNeg;
    else if ( pcur[Y] > 0.0 ) adir = DirPlus;
    else if ( pcur[Y] < 0.0 ) adir = DirNeg;

    CheckNextVertexForDirection( pcur, pnext );
    DetermineConvexDirection( ccw );

    GITrace( 7,
	printf(
	    "First three indices [%d, %d, %d], know,outside,ccw = %d, %g, %g\n",
			0, i1, i2, knowOutside, outside, ccw );
    )
    TraceResults;
    ptemp = pnext;
	    pnext = pcur;
		    pcur = ptemp;		/* swap vector ptrs */

    /***** go around polygon checking turn every 3 non-coincident vertices */
    for ( i1 = i2, ++i2;    i2 < nvert;    i2++ ) {
	pnext[X] = pVert[i2][X] - pVert[i1][X];
	pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
	if ( pnext[X] == 0.0  &&  pnext[Y] == 0.0 )
	    continue;

	/* we have another non-coincident point */
	CheckNextVertexForDirection( pcur, pnext );
        if ( TooManyTurns ) return( ReturnNonConvex );

	ccw = GIScalerCrossZ( pcur, pnext );
	if ( !knowOutside && ccw ) 
	    DetermineConvexDirection( ccw );

	TraceResults;
	if ( ccw * outside < 0.0 )
	    return( ReturnNonConvex );		/* found wrong turn */
	i1 = i2;
	ptemp = pnext;
		pnext = pcur;
			pcur = ptemp;		/* swap vector ptrs */
    }

    /***** and another cross product */
    i2 = 0;
    pnext[X] = pVert[i2][X] - pVert[i1][X];
    pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
    CheckNextVertexForDirection( pcur, pnext );
    if ( TooManyTurns ) return( ReturnNonConvex );
    ccw = GIScalerCrossZ( pcur, pnext );
    if ( !knowOutside && ccw ) 
	DetermineConvexDirection( ccw );
    TraceResults;
    if ( ccw * outside < 0.0 )
	return( ReturnNonConvex );		/* found wrong turn */
    i1 = i2;
    ptemp = pnext;
	    pnext = pcur;
		    pcur = ptemp;           	/* swap vector ptrs */

    /***** and one more cross product to first non-coincident */
    i2 = firsti1;
    pnext[X] = pVert[i2][X] - pVert[i1][X];
    pnext[Y] = pVert[i2][Y] - pVert[i1][Y];
    ccw = GIScalerCrossZ( pcur, pnext );
    if ( !knowOutside && ccw ) 
	DetermineConvexDirection( ccw );
    TraceResults;
    if ( ccw * outside < 0.0 )
	return( ReturnNonConvex );		/* found wrong turn */

    if ( !knowOutside ) return( ReturnDegenerateConvex );
    return( ReturnConvex );
}
