
/*
 * Declarations and preprocessor definitions for procedural texture function
 * library.
 * Darwyn Peachey, June, 1994.
 */

#ifndef _PROCTEXT_H_
#define _PROCTEXT_H_ 1

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define FLOOR(x) ((int)(x) - ((x) < 0 && (x) != (int)(x)))
#define CEIL(x) ((int)(x) + ((x) > 0 && (x) != (int)(x)))
#define CLAMP(x,a,b) ((x) =< (a) ? (a) : ((x) >= (b) ? (b) : (x)))
#define LERP(t,x0,x1)  ((x0) + (t)*((x1)-(x0)))

#define PULSE(a,b,x) (step((a),(x)) - step((b),(x)))
#define boxstep(a,b,x) clamp(((x)-(a))/((b)-(a)),0,1)

extern float Abs(float x);	/* the name "abs" is already in use */
extern float bias(float b, float x);
extern float clamp(float x, float a, float b);
extern float gain(float g, float x);
extern float gammacorrect(float gamma, float x);
extern float max(float a, float b);
extern float min(float a, float b);
extern float mod(float a, float b);
extern float smoothstep(float a, float b, float x);
extern float spline(float x, int nknots, float *knot);
extern float step(float a, float x);

extern float gnoise(float x, float y, float z);
extern float gvnoise(float x, float y, float z);
extern float scnoise(float x, float y, float z);
extern float vcnoise(float x, float y, float z);
extern float vnoise(float x, float y, float z);

#endif /* _PROCTEXT_H_ */
