/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/* Form definition file generated with fdesign. */

#include "forms.h"
#include "picture.h"
#include "panels.h"

FL_FORM *Control_Panel;

FL_OBJECT
        *Create_Object_Button,
        *Modify_Object_Button,
        *Join_Object_Button,
        *Split_Object_Button,
        *Aperture_Slider,
        *Display_Normals_Button,
        *Display_B_boxes_Button,
        *Load_Button,
        *Write_Button,
        *Quit_Button,
        *Destroy_Object_Button;

void create_form_Control_Panel()
{
  FL_OBJECT *obj;
  Control_Panel = fl_bgn_form(FL_NO_BOX,350.0,250.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,350.0,250.0,"");
  Create_Object_Button = obj = fl_add_button(FL_NORMAL_BUTTON,180.0,70.0,150.0,20.0,"Create Object");
    fl_set_object_lcol(obj,5);
  Modify_Object_Button = obj = fl_add_button(FL_NORMAL_BUTTON,180.0,45.0,150.0,20.0,"Modify Object");
    fl_set_object_lcol(obj,4);
  Join_Object_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,60.0,150.0,30.0,"Join Object");
    fl_set_object_lcol(obj,1);
  Split_Object_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,20.0,150.0,30.0,"Split Object");
    fl_set_object_lcol(obj,4);
  Aperture_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,150.0,310.0,20.0,"Aperture");
    fl_set_object_color(obj,47,59);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Display_Normals_Button = obj = fl_add_lightbutton(FL_PUSH_BUTTON,20.0,110.0,150.0,30.0,"Display Normals");
  Display_B_boxes_Button = obj = fl_add_lightbutton(FL_PUSH_BUTTON,180.0,110.0,150.0,30.0,"Display B-boxes");
  Load_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,200.0,100.0,30.0,"Load");
    fl_set_object_lcol(obj,4);
  Write_Button = obj = fl_add_button(FL_NORMAL_BUTTON,130.0,200.0,100.0,30.0,"Write");
    fl_set_object_lcol(obj,5);
  Quit_Button = obj = fl_add_button(FL_NORMAL_BUTTON,240.0,200.0,90.0,30.0,"Quit");
    fl_set_object_lcol(obj,1);
  Destroy_Object_Button = obj = fl_add_button(FL_NORMAL_BUTTON,180.0,20.0,150.0,20.0,"Destroy Object");
    fl_set_object_lcol(obj,1);
  fl_end_form();
}

/*---------------------------------------*/

FL_FORM *Edit_Panel;

FL_OBJECT
        *Red_Slider,
        *Green_Slider,
        *Blue_Slider,
        *Color_Box,
        *Edit_Reflectivity_Input,
        *Edit_Emissivity_Input,
        *Edit_Ok_Button,
        *Edit_Cancel_Button,
        *Edit_Object_Name_Input,
        *Edit_Shadows_Button,
        *Add_Texture_Button;

void create_form_Edit_Panel()
{
  FL_OBJECT *obj;
  Edit_Panel = fl_bgn_form(FL_NO_BOX,350.0,280.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,350.0,280.0,"");
  Red_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,230.0,200.0,20.0,"Red");
    fl_set_object_color(obj,47,3);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Green_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,190.0,200.0,20.0,"Green");
    fl_set_object_color(obj,47,60);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Blue_Slider = obj = fl_add_valslider(FL_HOR_FILL_SLIDER,20.0,150.0,200.0,20.0,"Blue");
    fl_set_object_color(obj,47,12);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Color_Box = obj = fl_add_box(FL_DOWN_BOX,240.0,150.0,90.0,100.0,"");
    fl_set_object_color(obj,640,47);
  Edit_Reflectivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,20.0,110.0,144.8,20.0,"Reflectivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Edit_Emissivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,180.0,110.0,150.0,20.0,"Emissivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Edit_Ok_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,20.0,100.0,30.0,"Ok");
    fl_set_object_lcol(obj,60);
  Edit_Cancel_Button = obj = fl_add_button(FL_NORMAL_BUTTON,240.0,20.0,90.0,30.0,"Cancel");
    fl_set_object_lcol(obj,1);
  Edit_Object_Name_Input = obj = fl_add_input(FL_NORMAL_INPUT,20.0,70.0,210.0,20.0,"Object Name");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Edit_Shadows_Button = obj = fl_add_lightbutton(FL_PUSH_BUTTON,240.0,70.0,90.0,20.0,"Shadows");
  Add_Texture_Button = obj = fl_add_button(FL_NORMAL_BUTTON,130.0,20.0,100.0,30.0,"Add Texture");
    fl_set_object_lcol(obj,112);
  fl_end_form();
}

/*---------------------------------------*/

FL_FORM *Texture_Panel;

FL_OBJECT
        *Texture_Name_Browser,
        *Scale_Input,
        *Tex_Reflectivity_Input,
        *Tex_Emissivity_Input,
        *Texture_Box,
	*Texture_Pict,
        *Tex_Object_Name_Input,
        *Tex_Shadows_Button,
        *Tex_Ok_Button,
        *Tex_Cancel_Button,
        *No_Texture_Button;

void create_form_Texture_Panel()
{
  FL_OBJECT *obj;
  Texture_Panel = fl_bgn_form(FL_NO_BOX,350.0,310.0);
  obj = fl_add_box(FL_UP_BOX,0.0,0.0,350.0,310.0,"");
  Texture_Name_Browser = obj = fl_add_browser(FL_HOLD_BROWSER,20.0,160.0,150.0,120.0,"Texture Name");
    fl_set_object_color(obj,47,52);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Scale_Input = obj = fl_add_input(FL_FLOAT_INPUT,190.0,160.0,140.0,20.0,"Scale");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Tex_Reflectivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,20.0,110.0,150.0,20.0,"Reflectivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Tex_Emissivity_Input = obj = fl_add_input(FL_FLOAT_INPUT,180.0,110.0,150.0,20.0,"Emissivity");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Texture_Box = obj = fl_add_box(FL_DOWN_BOX,220.0,210.0,70.0,70.0,"");
    fl_set_object_color(obj,0,47);
  Tex_Object_Name_Input = obj = fl_add_input(FL_NORMAL_INPUT,20.0,70.0,210.0,20.0,"Object Name");
    fl_set_object_color(obj,39,47);
    fl_set_object_align(obj,FL_ALIGN_TOP);
  Tex_Shadows_Button = obj = fl_add_lightbutton(FL_PUSH_BUTTON,240.0,70.0,90.0,20.0,"Shadows");
  Tex_Ok_Button = obj = fl_add_button(FL_NORMAL_BUTTON,20.0,20.0,100.0,30.0,"Ok");
    fl_set_object_lcol(obj,60);
  Tex_Cancel_Button = obj = fl_add_button(FL_NORMAL_BUTTON,240.0,20.0,90.0,30.0,"Cancel");
    fl_set_object_lcol(obj,1);
  No_Texture_Button = obj = fl_add_button(FL_NORMAL_BUTTON,130.0,20.0,100.0,30.0,"No Texture");
    fl_set_object_lcol(obj,112);
  Texture_Pict =
    fl_add_free(FL_SLEEPING_FREE,
		(float)Texture_Box->x, (float)Texture_Box->y,
		(float)Texture_Box->w, (float)Texture_Box->h,
		"",
		picture_handle);
  fl_end_form();
}

/*---------------------------------------*/

void create_the_forms()
{
  create_form_Control_Panel();
  create_form_Edit_Panel();
  create_form_Texture_Panel();
}

