/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

			     PREPRAD
		     (Scene preparation program)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: select.c
  Description	: Routines de management de la selection
**************************************************************************/

#include <stdio.h>
#include <types.h>
#include <macros.h>
#include <ray.h>
#include <misc.h>
#include "prtype.h"
#include "preprad.h"
#include "select.h"

void select_obj(SCENE_OP scene, SELECTIONP select, VECTOR point, BOOLEAN poly)
/**************************************************************************
  But	: Determine l'objet touche par le rayon compris entre les points
	  start et end
  Entree: scene	    : la scene
	  select    : la selection (rendue)
	  point	    : l'origine du rayon dans l'espace ecran
	  poly	    : TRUE si on selectionne un polygone
  Sortie: neant
**************************************************************************/
{
  RAY	    ray;
  float	    max_dis;
  VECTOR    start, end;

  point[2] = -1.0;
  M4D_transform_point(start, point, scene->state.visu.unif2world);

  point[2] = 1.0;
  M4D_transform_point(end, point, scene->state.visu.unif2world);

  select->pure = NULL;
  select->tri  = NULL;
  select->elem = NULL;

  V_sub(ray.dir, end, start);
  max_dis = V_norm(ray.dir);
  V_normalize(ray.dir, ray.dir);
  V_copy(ray.org, start);

  if (!object_in_sight(select, &ray, scene, max_dis, poly))
    {
      select->pure = NULL;
      select->tri  = NULL;
      select->elem = NULL;
    }
}

OBJECT_OP select_box_obj(float x, float y,
			 BOX_OBJP tab, int nb_obj)
/**************************************************************************
  But	: Selectionne un objet dans la fenetre de hierarchie
  Entree: x,y	    : la position de la souris
	  tab	    : le tableau des objets
	  nb_obj    : le nombre d'objets
  Sortie: l'objet selectionne
**************************************************************************/
{
  int i;

  for(i = 0; i < nb_obj; i++)
    if ((tab[i].x-HALF_BOX <= x) && (tab[i].x+HALF_BOX >= x) &&
	(tab[i].y-HALF_BOX <= y) && (tab[i].y+HALF_BOX >= y))
      return tab[i].obj;

  return NULL;
}
