/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: rad.c
  Description	: Programme principal
**************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "types.h"
#include "macros.h"
#include "interface.h"
#include "rad.h"

int		linecount;
SCENE_O		the_scene;
BOOLEAN		min_size_set, tex_yes;
char		*scene_path, *off_path, *tex_path;

long int	nb_rays, nb_tests, nb_hits,
		nb_bbox_hits, nb_bbox_trials, nb_nif_tests,
		nb_int_cuts, nb_shad_test_av,
		nb_patch, nb_tri;

yyerror(char *s)
/**************************************************************************
  But	: Fonction de signalisation d'erreur utilisee par yacc(gram.y)
  Entree: s :	la chaine de caractere a afficher
  Sortie: neant
**************************************************************************/
{
  printf("%s. Line: %d\n", s, linecount);
}

void init_glob_var()
/**************************************************************************
  But	: Initialise les variables globales
  Entree: neant
  Sortie: neant
**************************************************************************/
{
  scene_path = getenv("RADSCENE");
  off_path   = getenv("RADOFF");
  tex_path   = getenv("RADTEX");

  linecount	= 0;
  min_size_set	= FALSE;
  tex_yes	= getgdesc(GD_TEXTURE);
  the_scene.state.min_size   = 0.0;
  the_scene.state.nb_tex     = 1;
  the_scene.scene	     = NULL;

  nb_rays = nb_tests = nb_hits = nb_bbox_hits = nb_patch = nb_tri = 0;
  nb_bbox_trials = nb_nif_tests = nb_int_cuts = nb_shad_test_av = 0;
}

void print_statistics()
/**************************************************************************
  But	: Affiche les resultats statistiques
  Entree: neant
  Sortie: neant
**************************************************************************/
{
  printf("\nGeneral Statistics:\n");
  printf("Number of triangles (original/total):\t%10ld%10ld\n", nb_patch, nb_tri);
  printf("Number of negative 'in front' tests:\t%10ld\n", nb_nif_tests);
  printf("Number of intensity cuts: \t\t%10ld\n", nb_int_cuts);
  printf("Number of shadow tests avoided: \t%10ld\n", nb_shad_test_av);
  printf("\nRay-Tracing Statistics:\n");
  printf("Number of rays shot:\t\t\t%10ld\n", nb_rays);
  printf("Number of intersection tests:\t\t%10ld\t(%.2f per ray)\n",
	 nb_tests, (float)nb_tests/(float)nb_rays);
  printf("Number of hits on polygons:\t\t%10ld\t(%.2f%%)\n",
	 nb_hits, 100.0*(float)nb_hits/(float)nb_rays);
  printf("Number of tests on bounding boxes:\t%10ld\n", nb_bbox_trials);
  printf("Number of hits on bounding boxes:\t%10ld\t(%.2f%%)\n",
	 nb_bbox_hits, 100.0*(float)nb_bbox_hits/(float)nb_bbox_trials);
}

main(int    argc,
     char   *argv[])
/**************************************************************************
  But	: Fonction principale de RAD
  Entree: les arguments standards
  Sortie: neant
**************************************************************************/
{
  init_glob_var();
  the_scene.textures = (TEXTUREP)malloc(sizeof(TEXTURE)*MAX_TEX);
  assert(the_scene.textures);

  run_display(&the_scene);

  print_statistics();
}
