/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: types.h
  Description	: Fichier de definition des types de base (include)
**************************************************************************/

#ifndef types_h
#define types_h

#include <gl.h>
#include "constants.h"

typedef enum {
	pure_type,
	composite_type,
	assembly_type,
	unknown
	} Object_type;

typedef enum {
	poly_type,
	subdiv_type
	} Tri_type;

typedef enum {
	des_type,
	cal_type
	} File_type;

typedef enum {
	do_save,
	dont_save,
	do_cancel
	} Choice;

typedef enum {
	walkthru_mode,
	select_mode
	} Mode;

typedef char BOOLEAN;

typedef char NAME[NAME_SIZE];
typedef char STR[STRING_SIZE];

typedef float  VECTOR[3];
typedef float  VECTOR_4D[4];
typedef VECTOR *VECTORP;

typedef float  MATRIX[3][3];

typedef struct {
	float  inf, sup;
	} INTERVAL;

typedef struct {
	INTERVAL x, y, z;
	} VOXEL, *VOXELP;

typedef struct object;

typedef struct {
	float 	    id;			/* Identificateur */
	VECTOR	    point;
	VECTOR	    B, dB,
		    rB;			/* Total de la radiosite RECUE */
	int	    db;			/* Numero du vecteur dB qui vient
					   d'etre calcule pour la derniere
					   patch source */
	BOOLEAN	    update;		/* Utilise dans complete_rad */
	} VERTEX, *VERTEXP;

typedef struct element {
	short int   vertex[3];		/* Points formant l'element (indices) */
	float 	    surface;		/* La surface de l'element */
	struct tri  *sons;		/* La subdivision de l'element */
	} ELEMENT, *ELEMENTP;

typedef struct tri;
typedef struct subdiv {
	struct tri  *dad;		/* Le pere de la subdivision */
	ELEMENT	    elements[4];	/* Les elements de la subdivision */
	} SUBDIV;

typedef struct {
	VECTOR	    point;
	ELEMENTP    el;
	float 	    a, b, c;
	} SAMPLE, *SAMPLEP;

typedef struct {
	SAMPLE	array[NB_SAMPLES][NB_SAMPLES];
	} SAMPLE_ARR, *SAMPLE_ARRP;

typedef struct poly {
	int	    nb_v;		/* Nombre de sommets */
	int	    nb_tot;		/* Nombre de place dans le tableau */
	VERTEXP	    vertex;		/* Tableau des sommets */
	float 	    surface, d;		/* d => equation du plan du poly */
	VECTOR	    normal, sa, sb;
	SAMPLE_ARR  *samples;
	struct tri  *sons;		/* La subdivision du patch */
        } POLY, *POLYP;

typedef struct tri {
	Tri_type	type;
	struct object	*dad;		/* L'objet contenant le patch */
	union {
		POLY	poly;
		SUBDIV	subdiv;
	      }		tri;
	} TRIANGLE, *TRIANGLEP;

typedef struct {
	int	    size;
	int	    maxr;
	TRIANGLEP   data;
	} DATAS;

typedef struct {
	float 		E;
	TRIANGLEP	patch;
	int		o, p;
	} SHOOT_P, *SHOOT_PP;

typedef struct poly_l {
	TRIANGLE	*tri;
	struct poly_l	*next;
	} POLY_L, *POLY_LP;

typedef struct {
	int	nb_vox[3];		/* Nb de voxels en x, y, z */
	VECTOR	size;			/* Taille des voxels en x, y, z */
	VECTOR	org;			/* Origine du sous-espace */
	POLY_LP	*list;			/* Tableau des listes de polys */
	} GRID, *GRIDP;

typedef struct {
	STR		name;		/* Nom du fichier */
	unsigned long	*image;		/* L'image de texture */
	int		width, height;	/* Taille de l'image en pixels */
	VECTOR		meancolor;	/* Couleur moyenne de la texture */
	} TEXTURE, *TEXTUREP;

typedef struct {
	float		s[4], t[4];	/* Les equations des plans directeurs */
	float		scale;		/* L'echelle */
	int		index;		/* L'indice de la texture dans l'ENVIRONEMENT */
	} TEXMAP, *TEXMAPP;

typedef struct {
	int		id;		/* Numero de l'objet */
	float 		ro, E;
	BOOLEAN		shadows;	/* TRUE si l'objet projette une ombre */
	VECTOR		color;
	TEXMAP		texmap;		/* Informations sur la texture */
	int		nb_polys;	/* Nombre de polygones */
	TRIANGLEP	polys;		/* Tableau de polygones */
	GRIDP		grid;		/* Struct de subdiv unif de l'espace */
	} PURE_O, *PURE_OP;
	
typedef struct {
	GRID		*grid;		/* Struct de subdiv unif de l'espace */
	struct object	*sons;		/* La liste des fils */
	} COMPOSITE_O;

typedef struct {
	struct object	*sons;		/* La liste des fils */
	} ASSEMBLY_O;

typedef struct object {
	Object_type	type;
	struct object	*dad;		/* Le pere */
	struct object	*next;		/* Le suivant dans la liste */
	NAME		name;
	VECTOR		bbox[2];	/* Bounding box */
	union {
		PURE_O		pure;
		COMPOSITE_O	composite;
		ASSEMBLY_O	assembly;
	      } object;
	} OBJECT_O, *OBJECT_OP;

typedef struct {
	Angle		fovy;
	Coord		near, far;
	Matrix		rot, trans, mod, imod, view,	    /* viewing = mod * view */
			viewing, iviewing,
			persp, ipersp,
			unif2world, world2unif;
	} VISU_BLK;

typedef struct {
	float		min_size, min_size_s;
	int		o, p;
	OBJECT_OP	complex[MAX_DEPTH];
	OBJECT_OP	pure;
	SHOOT_P		shooting_p;
	SHOOT_P		new_shoot;
	BOOLEAN		not_done;
	int		nb_tex;
	VISU_BLK	visu;
	} STATE_BLK, *STATE_BLKP;

typedef struct {
	STATE_BLK	state;
	TEXTUREP	textures;
	OBJECT_OP	scene;
	} SCENE_O, *SCENE_OP;

typedef struct {
	VECTOR		org;
	VECTOR		dir;
	} RAY, *RAYP;

typedef struct {
	OBJECT_OP	pure;
	TRIANGLEP	tri;
	ELEMENTP	elem;
	float		dist;
	} SELECTION, *SELECTIONP;

typedef struct {
	SELECTION	select;
	VECTOR		color;
	float		ro;
	float		E;
	int		cur_tex, sel_tex;
	float		scale;
	} MODIF, *MODIFP;

#endif
