/* geomlist.h: lineaire lijsten van GEOMs */

#ifndef _GEOMLIST_H_
#define _GEOMLIST_H_

#include "geom_type.h"
#include "List.h"

typedef struct GEOMLIST {
	struct GEOM *geom;
	struct GEOMLIST *next;
} GEOMLIST;

#define GeomListCreate	(GEOMLIST *)ListCreate

#define GeomListAdd(geomlist, geom)	\
        (GEOMLIST *)ListAdd((LIST *)geomlist, (void *)geom)

#define GeomListCount(geomlist) \
        ListCount((LIST *)geomlist)

#define GeomListGet(geomlist, index) \
        (GEOM *)ListGet((LIST *)geomlist, index)

#define GeomListDuplicate(geomlist) \
        (GEOMLIST *)ListDuplicate((LIST *)geomlist)

#define GeomListNext(pgeomlist) \
        (GEOM *)ListNext((LIST **)pgeomlist)

#define GeomListMerge(geomlist1, geomlist2) \
        (GEOMLIST *)ListMerge((LIST *)geomlist1, (LIST *)geomlist2);

#define GeomListRemove(geomlist, geom) \
        (GEOMLIST *)ListRemove((LIST *)geomlist, (void *)geom)

#define GeomListIterate(geomlist, proc) \
        ListIterate((LIST *)geomlist, (void (*)(void *))proc)

#define GeomListIterate1A(geomlist, proc, data) \
        ListIterate1A((LIST *)geomlist, (void (*)(void *, void *))proc, (void *)data)

#define GeomListIterate1B(geomlist, proc, data) \
        ListIterate1B((LIST *)geomlist, (void (*)(void *, void *))proc, (void *)data)

#define GeomListDestroy(geomlist) \
        ListDestroy((LIST *)geomlist)

#include "ray.h"
extern float *GeomListBounds(GEOMLIST *geomlist, float *boundingbox);

extern struct PATCH *GeomListIntersect(GEOMLIST *geomlist, RAY *ray, float mindist, float *maxdist, int ShadowTesting);

extern void GeomListPrint(FILE *out, GEOMLIST *geomlist);

extern struct PATCHLIST *BuildPatchList(GEOMLIST *world, struct PATCHLIST *patchlist);

#endif /* _GEOMLIST_H_ */
