/* material.h */

#ifndef _MATERIAL_H_
#define _MATERIAL_H_

#include <stdio.h>
#include "color.h"

typedef struct MATERIAL {
	COLOR	Ka, 	/* ambiente kleur */
	        Kd, 	/* diffuse kleur */
	        Ks, 	/* speculaire kleur */
	        Ed;	/* diffuse emissie */
	float	Ns;	/* Phong exponent */
	char	*name;	/* naam voor het materiaal */
} MATERIAL;

extern MATERIAL defaultMaterial;

extern MATERIAL *MaterialCreate(char *name, COLOR *Ka, COLOR *Kd, COLOR *Ks, COLOR *Ed, float Ns);
extern void MaterialDestroy(MATERIAL *material);
extern MATERIAL *MaterialDuplicate(MATERIAL *material);
extern void MaterialPrint(FILE *out, MATERIAL *material);
extern void MaterialCopy(MATERIAL *src, MATERIAL *dest);

#endif /*_MATERIAL_H_*/
