/* NPGL.c */

#include <stdio.h>

#include <Xm/Xm.h>
#include <Xm/DrawingA.h>

#include "render.h"
#include "canvas.h"
#include "camera.h"
#include "scene.h"
#include "error.h"

typedef struct RENDEROPTIONS {
	char	gouraud_shading,  /* True voor Gouraudshading, False voor flat shading */
		draw_outlines,	  /* True om randjes van facetten te tekenen */
	        showlinks,	  /* True om ook de links te laten zien */
	        backface_culling, /* True om backface_culling te doen */
	        mode;		  /* REFLECTIVITY, RADIOSITY, ... */
	COLOR 	outline_color,	  /* kleur waarin randjes van facetten getekend worden */
	        link_color;	  /* kleur waarin links geteknd moeten worden */
} RENDEROPTIONS;

static RENDEROPTIONS renderopts;

void RenderSetOptions(char gouraud_shading, 
		      char backface_culling,
		      char draw_outlines, 
		      COLOR *outline_color,
		      char showlinks,
		      COLOR *link_color)
{
	renderopts.gouraud_shading = gouraud_shading;
	renderopts.backface_culling = backface_culling;
	renderopts.draw_outlines = draw_outlines;
	renderopts.outline_color = *outline_color;
	renderopts.showlinks = showlinks;
	renderopts.link_color = *link_color;
}

void RenderSetGouraudShading(char gouraud_shading)
{
	renderopts.gouraud_shading = gouraud_shading;	
}

void RenderSetBackfaceCulling(char backface_culling)
{
	renderopts.backface_culling = backface_culling;
}

void RenderSetOutlineDrawing(char draw_outlines)
{
	renderopts.draw_outlines = draw_outlines;
}

void RenderSetOutlineColor(COLOR *outline_color)
{
	renderopts.outline_color = *outline_color;
}

void RenderShowLinks(char showlinks)
{
	renderopts.showlinks = showlinks;
}

void RenderSetLinkColor(COLOR *link_color)
{
	renderopts.link_color = *link_color;
}

void RenderSetMode(char mode)
{
	renderopts.mode = mode;
}

char RenderGetMode(void)
{
	return renderopts.mode;
}

void RenderClearWindow(void)
{
}

/* bepaal afstand tot front- en backclipping plane */
void RenderGetNearFar(float *near, float *far)
{
	BOUNDINGBOX bounds;
	VECTOR b[2];
	int i, j, k;
	float z;

	GeomListBounds(World, bounds);

	b[0] = *(VECTOR *)&bounds[MIN_X];
	b[1] = *(VECTOR *)&bounds[MAX_X];

	*far = -HUGE; *near = HUGE;
	for (i=0; i<=1; i++)
		for (j=0; j<=1; j++)
			for (k=0; k<=1; k++) {
				z = (b[i].x - Camera.eyep.x) * Camera.Z.x +
				    (b[j].y - Camera.eyep.y) * Camera.Z.y +	
				    (b[k].z - Camera.eyep.z) * Camera.Z.z;
				if (z > *far) *far = z;
				if (z < *near) *near = z;
			}

	*far += EPSILON; *near -= EPSILON;
	if (*far < EPSILON) *far = Camera.viewdist;
	if (*near < EPSILON) *near = Camera.viewdist/100.;
}

void RenderSetCamera(void)
{
	RenderClearWindow();
}

/* open window for rendering */
Widget RenderCreateWindow(Widget parent)
{
	Widget canvas;

	canvas = XtVaCreateManagedWidget("canvas",
					 xmDrawingAreaWidgetClass,
					 parent, 
					 NULL);

/* window wordt zichbaar */
	XtAddCallback(canvas, XmNexposeCallback, CanvasExposeCallback, (XtPointer)NULL);

/* window resizes */
	XtAddCallback(canvas, XmNresizeCallback, CanvasResizeCallback, (XtPointer)NULL);

/* muis bewegingen */
	XtAddEventHandler(canvas, 
			  ButtonPressMask | ButtonReleaseMask | ButtonMotionMask,
			  False,	/* geen non-maskable event */
			  (XtEventHandler)CanvasMouseEvent,
			  (XtPointer)NULL);	/* client_data */

	return canvas;
}

void RenderElementOutline(PATCH *patch)
{
}

void PatchRenderLinks(PATCH *patch)
{
}

void RenderScene(void)
{
}

unsigned long *GetIDs(long *x, long *y)
{
	*x = *y = 0;
	return (unsigned long *)NULL;
}

void SaveScreen(FILE *fp)
{
}
