/* vertex.h */

#ifndef _VERTEX_H_
#define _VERTEX_H_ 1

#include <stdio.h>

#include "point.h"
#include "vector.h"
#include "patchlist.h"
#include "color.h"

typedef struct VERTEX {
	POINT  *point;
	VECTOR *normal;
	struct PATCHLIST  *patches;
	RGB    color;
} VERTEX;

extern VERTEX *VertexCreate(POINT *point, VECTOR *normal, struct PATCHLIST *patches, RGB *color);

extern void VertexDestroy(VERTEX *vertex);

extern void VertexPrint(FILE *out, VERTEX *vertex);

extern int GetNumberOfVertices(void);

#endif /*_VERTEX_H_*/
