/* stupidmalloc.c,v 1.1.1.1 1995/02/27 07:38:52 explorer Exp */

#include <sys/types.h>
#include <stdlib.h>
#include <stdio.h>

#define STEP (1024 * 128)

void *
stupid_malloc(size_t size)
{
  static size_t bytes_left = 0;
  static char *buf;
  static size_t step = STEP;
  static char *current;
  void *result;

  if (!step) {
    return NULL;
  }

  if (step < size) {
    return malloc(size);
  }

  if (bytes_left < size) {
    buf = NULL;
    while (!buf && step) {
      buf = malloc(step);
      if (!buf) {
        step >>= 1;
      }
    }
    if (!step) {
      return NULL;
    }else{
      current = buf;
      bytes_left = step;
    }
  }

  result = current;
  current += size;
  bytes_left -= size;

  return result;
}

void
stupid_free(void *p)
{
  return;
}
