.TH SEGAL 1 "1 May 1990" "LBL"
.SH NAME
.B segal
- (SEGmentation AnaLyzer): binary mask editor/builder/analyzer for HIPS images.
.SH SYNOPSIS
.B segal
[-i image][-m mask] [-v] [-c NN]
.SH DESCRIPTION
.I segal
is an X-windows  tool for interactively editing, creating, and analyzing
binary mask images. In
.I segal
a mask is transparently laid over the original image, then using the
mouse, one can "cut" or "fill" in the mask, exposing the image beneath.
A new mask can be created by selecting the image threshold value.
The user can select between various size paint/erase cursors, and 
select various zoom magnifications, to aid in building the mask.
The image must be of type byte, and it is best if the image is contrast
enhanced using a program such as
.I mahe
or
.I
hstr.
A mask can also be edited/created without an image overlay.
.I segal
also does statistical measurements on objects in the binary mask image.
.SH OPTIONS
.TP
.B \-i image
image file name (must have HIPS header)
.TP
.B \-m mask
binary mask image file name (must have HIPS header)
.TP
.B \-v
sets 
.I segal
to verbose mode, which prints several status/debugging messages
along the way.
.TP
.B \-c NNN
Sets the color (Hue) of the overlay blend. This number is an integer
value for the hue ( must be 0 to 360 ). Default value is 170 (dark green).
.LP
This program was coded using the xview toolkit, which follows Sun's
Openwindows/ OPEN LOOK specifications. Therefore most of the standard
xview windows arguments should work, as well as anything
specified with OpenWindows.foo in your .Xdefaults file.
In particular, use "OpenWindows.WindowColor:  colorname" in the .Xdefaults
file to set the background color for the control panels.
.TP
Here are some standard xview options that may be useful:
.TP
.B \-display hostname:display
Specify the name of the display to manage.  Overrides the DISPLAY
environment variable, if any.
.TP
.B \-position x y
Location of the
.I segal
control window.
.TP
.B \-foreground_color red green blue
Sets text in the control windows to the color specified by (red, green, blue)
.TP
.B \-help
List of all window control command arguments.
.\"===============================================================
.SH MAIN CONTROL WINDOW FUNCTIONS
.TP 10
.B load:
checks if either the image or the mask filename have
changed, and if so, loads and displays the new file.
.TP 10
.B quit:
exits
.I segal.
.TP 10
.B save:
save the current frame of the mask
.TP 10
.B restore:
undo the changes since the last 'save'.
.TP 10
.B step:
go to the next (or previous) frame in a multi-frame sequence.
.TP 10
.B mode:
.I view
= view image and mask, 
.br
.I zoom 
= zoom image and mask,
.br
.I edit
= zoom and edit.  (Note: can only edit the mask, not the image)
.br
The reason for separate  'zoom' and 'edit' modes is so that
if you only want to zoom the image, you don't have to worry about
accidentally modifying the mask.
.TP 10
.B display:
which image to display: image, mask, or blend of both.
.TP 10
.B contrast:
adjust contrast of image (gamma correction).
.TP 10
.B combine:
.I color blend:
use a transparent color blend to see the image through the mask.
.br
.I overlay: 
just overlay mask over the image
.TP 10
.B mask model:
.I cut: 
start with solid mask and cut holes
.br
.I build: 
start with no mask and paint objects
.TP 10
.B threshold:
This is the value to threshold the image at when creating a new mask.
NOTE: when stepping to the next or previous frame, it is necessary to
click on the slider to threshold the new frame.
.TP 10
.B Polygon Mask:
When this option is selected, mouse clicks in the view window create
vertices for a polygon mask. The 'Show' button connects the vertices
of the polygon, the 'Fill' button fills in the polygon, creating
the mask, and the 'Clear' button removes all vertices.
.TP 10
.B opacity sliders:
adjust opacity/transparency of image and mask for blend.
.sp
.SH MOUSE BUTTON OPERATIONS
Left, middle, and right mouse buttons all have the same effect.
.TP 40
.B VIEW and ZOOM windows
.TP 10
.B shift or control, mouse button:
Display the gray level value of the pixel at the tip of the mouse pointer.
.TP 10
.B meta, mouse button:
Compute statistics on the object (defined by the mask) under the mouse
pointer. These statistics include object size, total intensity, average
intensity, and perimeter.
.TP 20
.B View Window Only
.TP 10
.B any mouse button:
Move the zoom window. Area is zoomed when button is released.
The zoom window is centered at the cursor location. This is
only active if the mode is zoom or edit.
.SH EDIT WINDOW FUNCTIONS
.TP 12
.B edit mode:
select between cut (paint) and fill (erase) modes
.TP 12
.B brush size:
select the size of the brush (cursor)
.TP 12
.B cursor:
select between a round and a square cursor
.TP 12
.B zoom mag:
change the zoom magnification factor
.TP 12
.B save:
save the current frame of the mask
.TP 12
.B restore:
undo the changes since the last 'save'.
.TP 12
.B any mouse button:
Paint or erase the area under the cursor.
.SH ENVIRONMENT
.B DISPLAY
Specifies the screen for the program to be displayed at. To set, use
setenv. For example: setenv DISPLAY unix:0.0  for your local machine.
.SH TRADEMARKS
.LP
OPEN LOOK is a trademark of AT&T.
.br
The X Window system is  a  trademark  of  the  Massachusetts Institute
of Technology.
.br
OpenWindows is a trademark of Sun Microsystems, Inc.

.SH AUTHOR
Brian Tierney, LBL        email: bltierney@lbl.gov
.SH "SEE ALSO"
segal_tutorial(1), mahe(1), hstr(1), xinit(1), openwin(1), addmask(1)
.SH DIAGNOSTICS
.pp
This program currently prints most error messages to stderr ( the window
in which the program was started). If nothing happens when you think 
something should be happening, check for an error message in that window.
.SH BUGS
.pp
With large images, the image is sometimes only partially
displayed when first bringing up
the image window. The fix this, click the mouse in the button
labeled 'image'.
.pp
The largest paint and erase cursors sometimes 'break up' when moving
on the edit window. I believe this must be a xview toolkit bug.
.pp
Report all other bugs to Brian Tierney.

