/*	Copyright (c) 1982 Michael Landy, Yoav Cohen, and George Sperling

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.   */

/*
 * neg - takes photographic negative of
 * input image by inverting bits. Input image
 * is either byte, integer, single-bit/bit packed, or 
 * floating.
 *
 * usage:	neg <iseq >oseq
 *
 * to load:	cc -o neg neg.c -lhipl
 *
 * Mike Landy - 5/27/82
 * Added short data type
 * 	WEJohnston - 9/89
 */

#include <stdio.h>
#include <hipl_format.h>
char Progname[]="neg";

main(argc,argv)

char *argv[];

{
	int	f,factor,fr,r,c,b,i,j,k;
	struct	header hd;
	char	*bfr,*bp;
	float	*ffr,*fp;
	int	*ifr,*ip;
	short	*sfr,*sp;

	read_header (&hd);
	if(hd.pixel_format != PFBYTE && hd.pixel_format != PFFLOAT &&
			hd.pixel_format != PFINT && hd.pixel_format != PFSHORT)
		perr("pixel format must be byte, short, integer or floating");
	r = hd.rows; c = hd.cols;
	fr = hd.num_frame;
	update_header (&hd,argc,argv);
	write_header (&hd);
	if (hd.pixel_format == PFBYTE) { /******** byte image ********/
		if (hd.bits_per_pixel == 1 && hd.bit_packing != 0)
			c = (c+7)/8;
		bfr = (char *) halloc(r*c,sizeof (char));
		for (f=0;f<fr;f++) {
			if (pread(0,bfr,r*c*sizeof(char)) != r*c*sizeof(char))
				perr("error during read");
			bp = bfr;
			for (i=0;i<r;i++) {
				for (j=0;j<c;j++) {
					*bp++ = *bp ^ 0377;
				}
			}
			if (write(1,bfr,r*c*sizeof(char)) != r*c*sizeof(char))
				perr("error during write");
		}
	}
	else if (hd.pixel_format == PFSHORT) { /******** short image ********/
		sfr = (short *) halloc(r*c,sizeof (short));
		for (f=0;f<fr;f++) {
			if (pread(0,sfr,r*c*sizeof(short)) != r*c*sizeof(short))
				perr("error during read");
			sp = sfr;
			for (i=0;i<r;i++) {
				for (j=0;j<c;j++) {
					*sp++ = -*sp;
				}
			}
			if (write(1,sfr,r*c*sizeof(short)) != r*c*sizeof(short))
				perr("error during write");
		}
	}
	else if (hd.pixel_format == PFINT) { /******** integer image ********/
		ifr = (int *) halloc(r*c,sizeof (int));
		for (f=0;f<fr;f++) {
			if (pread(0,ifr,r*c*sizeof(int))!=r*c*sizeof(int))
				perr("error during read");
			ip = ifr;
			for (i=0;i<r;i++) {
				for (j=0;j<c;j++) {
					*ip++ = -*ip;
				}
			}
			if (write(1,ifr,r*c*sizeof(int))!=r*c*sizeof(int))
				perr("error during write");
		}
	}
	else { /******** floating image ********/
		ffr = (float *) halloc(r*c,sizeof (float));
		for (f=0;f<fr;f++) {
			if (pread(0,ffr,r*c*sizeof(float))!=r*c*sizeof(float))
				perr("error during read");
			fp = ffr;
			for (i=0;i<r;i++) {
				for (j=0;j<c;j++) {
					*fp++ = -*fp;
				}
			}
			if (write(1,ffr,r*c*sizeof(float))!=r*c*sizeof(float))
				perr("error during write");
		}
	}
	return(0);
}
