/*	Copyright (c) 1982 Michael Landy, Yoav Cohen, and George Sperling

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.   */

/* exppix.c - replace each pixel by exp(pixel value * scale) 
 *		 for each frame.
 *		
 * usage: exppix [scale] <frame >new_frame
 *	  scale defaults to 1.0
 *
 * to load: compile exppix 
 *
 * Yoav Cohen 2/16/82
 * Ann Adams 4/13/87
 */

#include <hipl_format.h>
#include <math.h>
#include <stdio.h>
char *Progname;

float *pic,*p;
float *opic,*op;

main(argc,argv)

int argc;
char *argv[];
{
	double atof();
	struct header hd;
	int frame;
	float scale;

	Progname = strsave(*argv);
	if (argc == 1) scale = 1.0;
	else scale = atof(argv[1]);
	read_header(&hd);
	if(hd.pixel_format != PFFLOAT)
		perr("image pixel format must be floats");
	write_header(&hd);
	pic = (float *) halloc(hd.rows*hd.cols,sizeof(float));
	opic = (float *) halloc(hd.rows*hd.cols,sizeof(float));
	for(frame=0;frame<hd.num_frame;frame++)
		exppix(hd.rows,hd.cols,scale);
	return(0);
}

exppix(r,c,sc)
int r, c;
float sc;
{
	int	i,rc;
	double 	exp();
	double 	a;     

	rc=r*c;
	if (pread(0,pic,rc*sizeof(float)) != rc*sizeof(float))
		perr("error during read");
	p = pic;
	op = opic;
	for (i=0;i<rc;i++) {
		a = exp((double)(*p++) * sc);
		*op++ = (float)(a);
	}
	if (write(1,opic,rc*sizeof(float)) != rc*sizeof(float))
		perr("error during write");
	return(0);
}
