/*	Copyright (c) 1982 Mickael Landy, Yoav Cohen, and George Sperling

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.    */

/*
 * mkheader.c - create a header from the argument list and append the
 *		standard input
 *
 * Usage:
 *   mkheader <File name> [rows [cols [frames]]] [-BSIFC]
 *
 * Defaults:
 *	rows = 256, cols = 256, frames = 1
 *	-B for PFBYTE
 *
 * Load:	cc -O -o mkheader mkheader.c -lhips
 *
 * Michael Landy/ Yoav Cohen - 2/4/82
 * Charles Carman (BME dept. UVA) - 5/08/87
 *
 * modified to pad image with zeros if input file is smaller than
 *  the size given.  -Brian Tierney, LBL  10/90
 */
#include <stdio.h>
#include <hipl_format.h>
char     *Progname;

main(argc, argv)
    int       argc;
    char    **argv;
{
    struct header hd;
    int       rows, cols, frames, format, bpp;
    int       i, image_size, rsize;
    char     *buf, *zbuf, *malloc();

    Progname = strsave(*argv);
    if (argc < 2 || argc > 6)
	usageterm();

    if (strcmp(argv[1], "-h") == 0)
	usageterm();

    cols = rows = 512;
    frames = 1;
    format = PFBYTE;
    bpp = 8;

    for (i = 2; i < argc; i++) {
	if (*argv[i] == '-') {
	    switch (*(++argv[i])) {
	    case 'B':
		format = PFBYTE;
		bpp = 8;
		break;
	    case 'C':
		format = PFCOMPLEX;
		bpp = 64;
		break;
	    case 'F':
		format = PFFLOAT;
		bpp = 32;
		break;
	    case 'I':
		format = PFINT;
		bpp = 32;
		break;
	    case 'S':
		format = PFSHORT;
		bpp = 16;
		break;
	    default:
		perr("unknown parameter");
	    }
	} else
	    switch (i) {
	    case 2:
		rows = atoi(argv[i]);
		break;
	    case 3:
		cols = atoi(argv[i]);
		break;
	    case 4:
		frames = atoi(argv[i]);
		break;
	    }
    }

    init_header(&hd, argv[1], "", frames, "", rows, cols, bpp, 0, format, "");
    write_header(&hd);

    image_size = rows * cols * bpp / 8;
    buf = malloc(image_size);
    if (buf == NULL)
	perr("error allocating memory");
    for (i = 0; i < frames; i++) {
	rsize = pread(0, buf, image_size);
	if (rsize == image_size)
	    write(1, buf, image_size);
	else {			/* added 10/90, Brian Tierney, LBL */
	    fprintf(stderr, "Warning: image smaller than size specified, padding with zeros...\n");
	    write(1, buf, rsize);
	    zbuf = (char *) calloc(image_size - rsize, bpp);
	    write(1, zbuf, image_size - rsize);
	    free(zbuf);
	}
    }
    return (0);
}

/******************************************************************/
usageterm()
{
    perr("usage: mkheader <descrp> [rows [cols [frames]]] [-BSIFC] < infile > hipsfile");
}
