/* svdisplay.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


/* These procedures implement the routines necessary to handle Sunview window
  control routines.  These routines written by Antony
  A. Courtney, 5/11/89 and David Robertson 90 */

#include <stdio.h>
#include <math.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>
#include "svwin.h"


/* image_init:  initialize control panel and display window
   init_image_vars:  initialize image display information
   svanima_repaint:  repaint procedure
   display_frame:  display Anima frame */


Frame anima_control ;		/* control panel */
Frame image_win ;		/* display window */
Canvas image_canvas ;		/* display canvas */
Pixwin *canvas_svid ;
Pixrect *image_win_image ;

int S_zoom_changed = 0 ;		/* zoom or unzoom set */

int S_maxcol ;		/* maximum number of color map entries */
int S_mapnum ;		/* number of color map entries */
unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* color map */

struct image_stuff S_image_info ;	/* image information */

unsigned char *S_image_mem = NULL ;

unsigned char red[S_MAX_COL_SIZE],green[S_MAX_COL_SIZE],blue[S_MAX_COL_SIZE] ;

int prev_colors ;	/* number of color map entries in previous frame */

static char anima_format[80] ;	/* Anima format */

extern struct itimerval itimevalue;	/* timer value */




/* initialize control panel and display window */

image_init(argc,argv,winx,winy)

int argc ;
char *argv[] ;
int winx ;	/* upper left hand corner of panel */
int winy ;

{
    int i ;
    int n ;
    void svanima_repaint() ;

        /* initialize image size, etc. */
    init_image_vars() ;

	/* creates the control panel */
    anima_control = window_create(NULL, FRAME,
                          FRAME_LABEL, "svanima control",
			  FRAME_EMBOLDEN_LABEL, TRUE,
			  FRAME_SHOW_LABEL, TRUE,
                          WIN_X, winx,
                          WIN_Y, winy,
                          WIN_WIDTH, 628,
                          WIN_HEIGHT, 131,
                          WIN_SHOW, TRUE,
                          NULL);

    a_panel.panel = window_create(anima_control, PANEL,
                                  PANEL_LABEL_BOLD, TRUE,
                                  NULL);

    create_panel_items();

        /* creates the display window */
    image_win = window_create(anima_control, FRAME,
                              FRAME_LABEL, "Anima image",
                              FRAME_EMBOLDEN_LABEL, TRUE,
                              FRAME_SHOW_SHADOW, FALSE,
                              FRAME_SHOW_LABEL, TRUE,
                              WIN_X, 10,
                              WIN_Y, 140,
                              WIN_WIDTH, S_image_info.s_width+10,
                              WIN_HEIGHT, S_image_info.s_height+23,
                              WIN_SHOW, TRUE,
                              NULL);

    image_canvas = window_create(image_win, CANVAS,
                           CANVAS_AUTO_SHRINK, TRUE,
                           CANVAS_AUTO_EXPAND, TRUE,
			   CANVAS_RETAINED, FALSE,
			   CANVAS_REPAINT_PROC, svanima_repaint,
                           NULL);

    canvas_svid = canvas_pixwin (image_canvas);
    image_win_image = mem_create (S_image_info.s_width, S_image_info.s_height, 8);
    S_image_mem = (unsigned char *) mpr_d(image_win_image)->md_image;
	/* set timer value */
    itimevalue.it_value.tv_sec = itimevalue.it_interval.tv_sec = 0;
    itimevalue.it_value.tv_usec = itimevalue.it_interval.tv_usec =
		(50000 * (10 - S_avars.speed));
    notify_set_itimer_func(anima_control, frame_monitor, ITIMER_REAL,
                            &itimevalue, ((struct itimerval *) 0));

}




/* initialize image display information */

init_image_vars()

{
    S_image_info.s_height = S_DEF_WINSERV_HEIGHT ;
    S_image_info.s_width = S_DEF_WINSERV_WIDTH ;
    S_image_info.s_max_height = S_MAX_WINSERV_HEIGHT ;
    S_image_info.s_max_width = S_MAX_WINSERV_WIDTH ;

    S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
}




/* repaint proc */

void
svanima_repaint(canvas,pixwin,repaint_area)

Canvas canvas;
Pixwin *pixwin ;
Rectlist *repaint_area ;

{
  if (!S_dont_repaint)
    pw_rop(canvas_svid, 0, 0, S_image_info.s_width, S_image_info.s_height, PIX_SRC,
	   image_win_image, 0, 0) ;
}




/* display Anima frame */

display_frame ()

{
    int i ;
    int colors ;	/* number of color map entries */
    int height, width ;
    char s[12] ;
    int scry_xform_indices[256] ;	/* for compatibility with X version */
    int repaint_status ;

    S_image_info.compression = S_CCC ;
        /* Figure out where to get the next frame from. */
    if(S_avars.start)
        S_avars.current = 0;
    else if(S_avars.search)
    {
        panel_set_value(a_panel.frame, "");
        window_set(a_panel.panel,
                       PANEL_CARET_ITEM, a_panel.frame,
		       0);
        S_avars.stop = TRUE;
	S_avars.advance = FALSE ;
        S_avars.search = FALSE;
    }
	/* go back to beginning */
    else if((S_avars.current == S_avars.frame.last) &&
		  S_avars.direction == S_FORWARD)
    {
        S_avars.current = 0 ;
        S_avars.frame.last = S_anima_count - 1;
    }
    else
    {
        if(S_avars.direction == S_BACKWARD)
        {
            if (S_avars.current > 0)
                S_avars.current--;
            else
                S_avars.current = S_avars.frame.last ;
        }
        else if(S_avars.current < S_anima_count-1)
            S_avars.current++;
        if(S_avars.advance)
        {
            S_avars.stop = TRUE;
            S_avars.advance = FALSE;
        }
        else
            ;	
    }
	    
	/* seek to current Anima frame */
    fseek(S_anima_file, S_a_index[S_avars.current].offset, 0);
    panel_set_value(a_panel.gamma, "") ;

	/* read IFF header as necessary */
    if ((anima_format[0] == 'm') || S_avars.start || (S_avars.current == 0)) 
    {
        if(!iff_read_header(S_anima_file, &S_image_info, &height, &width, anima_format))
        {
	    fprintf (stderr,"iff_read_header failed\n") ;
	    exit(0) ;
        }
        if ((width > S_MAX_WINSERV_WIDTH) ||
	   (height > S_MAX_WINSERV_HEIGHT) ||
	   (width < 1) || (height < 1))
	   {
	       fprintf (stderr,"illegal sized image\n") ;
	       exit(0) ;
	   }
    
	    /* if frame different size */
        if ((((width != S_image_info.s_width) ||
	    (height != S_image_info.s_height))) && S_avars.start)
        {
	    repaint_status = S_dont_repaint ;
	    S_dont_repaint = 1 ;
#ifdef MESSAGES
	    fprintf (stderr,"new height, width = %d %d\n",height,width) ;
#endif
	    S_do_zoom = 0 ;
	    S_zoom_changed = 0 ;
		/* reset window size */
	    S_image_info.s_width = width ;
	    S_image_info.s_height = height ; 
            (void) window_set(image_win,
		    WIN_WIDTH, S_image_info.s_width+10,
		    WIN_HEIGHT, S_image_info.s_height+23,
		    NULL) ;
		/* redo image */
	    free(S_image_mem) ;
	    free(image_win_image) ;
	    free(S_image_info.data) ;
	    image_win_image = mem_create(S_image_info.s_width, S_image_info.s_height, 8) ;
	    S_image_mem = (unsigned char *) mpr_d(image_win_image)->md_image ;
	    S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
	    S_dont_repaint = repaint_status ;
        }
    }
	/* if zoomed or unzoomed */
    if (S_zoom_changed)
    {
	repaint_status = S_dont_repaint ;
	S_dont_repaint = 1 ;
	S_zoom_changed = 0 ;
#ifdef MESSAGES
	fprintf (stderr,"new height, width = %d %d\n",S_image_info.s_height,S_image_info.s_width) ;
#endif
        (void) window_set(image_win,
		WIN_WIDTH, S_image_info.s_width+10,
		WIN_HEIGHT, S_image_info.s_height+23,
		NULL) ;
	free(S_image_mem) ;
	free(image_win_image) ;
	free(S_image_info.data) ;
	image_win_image = mem_create(S_image_info.s_width, S_image_info.s_height, 8) ;
	S_image_mem = (unsigned char *) mpr_d(image_win_image)->md_image ;
	S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
	S_dont_repaint = repaint_status ;
    }
    if (S_image_info.compression != S_CCC)
    {
	fprintf (stderr, "can't handle non-CCC format\n") ;
	exit(0) ;
    }

/* get the image */

    S_image_info.total = S_a_index[S_avars.current].buf_total ;
    iff_read_buf(S_anima_file, &S_image_info);
    
/* Initialize Sun colormap memory. */
    memset((char *)red, 0, 256*sizeof(u_char));
    memset((char *)green, 0, 256*sizeof(u_char));
    memset((char *)blue, 0, 256*sizeof(u_char));

    if (S_mapnum > S_MAX_COL_SIZE)
    {
	fprintf (stderr,"illegal number of color map entries\n") ;
	fprintf (stderr,"exiting\n") ;
	exit(0) ;
    }

	/* get color map */
    for(i = 0; i < S_mapnum; i++)
    {
        red[i] = S_map[i][S_RED] ;
        green[i] = S_map[i][S_GREEN];
        blue[i] = S_map[i][S_BLUE];
    }
    if(S_mapnum < 255)
    {
	red[255] = green[255] = blue[255] = 0 ;
        red[254] = green[254] = blue[254] = 0xFF;
    }
	/* don't use all 256 colors unless absolutely necessary */
    if(S_mapnum <= 128)
        colors = 128;
    else 
        colors = 256;

        /* Change the segment if necessary. */
    if (S_avars.start == TRUE)
        sprintf(S_avars.segname, "%d %d\n", S_avars.pid, colors);
    else if (colors != prev_colors)
        sprintf(S_avars.segname, "%d %d\n", S_avars.pid, colors);
    pw_setcmsname(canvas_svid, S_avars.segname); /* assign segment name */
    prev_colors = colors ;


        /* Display the current frame number in the panel. */
    sprintf(s, "%d/%d", S_avars.current, S_anima_count);
    panel_set_value(a_panel.cur_frame, s);

        /* for compatibility with X version */
    for (i = 0 ; i < 256 ; i++)
        scry_xform_indices[i] = i ;

        /* Decompress the image and display it. */
    if (S_do_zoom)	/* zoom */
        zoom_decompress(S_image_info.data, S_image_mem, scry_xform_indices);
    else		/* normal */
        decompress_ccc(S_image_info.data, S_image_mem,S_image_info.s_height,S_image_info.s_width,scry_xform_indices) ;
	
	/* change gamma if it has been reset */
    if ((anima_format[0] == 'm') || S_avars.start || gamma_changed)
    {
	if (scry_gamma != 1.0)
	{
            for (i = 0; i < S_mapnum; i++)
	    {
	        red[i] = (int) (256. * pow((double) red[i] / 256., 1.0 / scry_gamma));
	        if (red[i] > 255)
	            red[i] = 255;
	        green[i] = (int) (256. * pow((double) green[i] / 256., 1.0 / scry_gamma));
	        if (green[i] > 255)
	            green[i] = 255;
	        blue[i] = (int) (256. * pow((double) blue[i] / 256., 1.0 / scry_gamma));
	        if (blue[i] > 255)
	            blue[i] = 255;
	    }
	}
	    /* reset color map */
        pw_putcolormap(canvas_svid, 0, colors, red, green, blue);
	gamma_changed = 0 ;
    }
	/* display image */
    pw_rop(canvas_svid, 0, 0, S_image_info.s_width, S_image_info.s_height, PIX_SRC, image_win_image, 0, 0);
    
    if(S_avars.start == TRUE)
	S_avars.start = FALSE;
    S_dont_repaint = 0 ;
    return(1);
}
