/* graph16.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <memory.h>
#include "scrysrv.h"
#include "image.h"

/* 16-bit frame buffer-dependent routines */

/* xdr_map:	XDR decodes incoming RGB color map and converts it to
		TARGA 16 format
   xdr_ccc_decompress:	decompresses and displays CCC and run length
		encoded image
   xdr_qdata:  converts 8-bit incoming image to TARGA 16 format and displays
   xdr_udata:  gets incoming 16-bit image and displays */



#define		SIZBLOC		4 	/* pixels in block side */
#define		SCANSIZE	512	/* maximum pixels in row */
#define		MAX_TO_READ	32764   /* 32K - (32K % SIZBLOC) */



/* XDR decodes incoming RGB color map and converts it to
   TARGA 16 format */

bool_t 
xdr_map (xdrsp,map)

XDR *xdrsp ;		/* XDR handle */
struct mapstore *map ;	/* color map */

{
    int i ;

	/* number of entries in color map */
    if (!xdr_long(xdrsp,&(map->num)))
        return (0) ;
#ifdef DEBUG
    printf ("map entries = %d\n",map->num) ;
#endif
    memset(map->s_map,'\0',256*3) ; 
    if (!xdr_opaque(xdrsp,map->s_map,map->num*3))
        return (0) ;
            /* convert it to TARGA 16-bit format */
    for (i = 0 ; i < map->num ; i++)
    {
        map->h_map[i] = ((map->s_map[i][RED] & 0xf8) << 7) |
                        ((map->s_map[i][GREEN] & 0xf8) << 2) |
                         (map->s_map[i][BLUE] >> 3) ;
    }
    return(1) ;
}




/* decompresses and displays CCC and run length encoded image */

bool_t 
xdr_ccc_decompress (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;

{
    long border_color ;		/* border color */
    int client_width ;		/* incoming image width */
    int block_width_num ;	/* number of blocks per 4 rows of image */
    int total_blocks ;		/* total 4x4 blocks in image */
    long current_block ;
    int run_ctr ;
    int row ;			/* row in TARGA 16 frame buffer */
    int decal ;			/* skips to next row */
    register unsigned char *ptin ;	/* incoming buffer pointer */
    unsigned char ind0, ind1 ;	/* indices to colors inside the block */
        /* TARGA 16 colors inside the block */
    register unsigned short pix0, pix1 ;
    register unsigned short *ptbloc ;	/* pointer to beginning of block */
    unsigned short part [SIZBLOC * 1024] ;	/* decompressed scan lines */
    long total_read ;		/* total bytes in compressed image */
    long total_to_read ;	/* total left to read */
    int bytes_processed ;	/* total bytes read in current chunk */
    register int j, k ;

    border_color = (long) (((back_red & 0xf8) << 7) |
			  ((back_green & 0xf8) << 2) |
                           (back_blue >> 3)) ;
    SetBorderColor(&border_color) ;
    client_width = (int) image_info->client_wd ;
    block_width_num = client_width / SIZBLOC ;
    decal = image_info->width + SIZBLOC - 1 ;
    total_blocks = block_width_num*((int)(image_info->client_ht)/SIZBLOC) ;
    row = (int)(image_info->height) - SIZBLOC ;
    for (k = 0 ; k < image_info->width * SIZBLOC ; k++)
	part[k] = (unsigned short) border_color ;
    for (k = 0 ; k < center_y_bottom ; k++)
    {
        PutRow (part,0,image_info->width-1,image_info->height-k-1,-1);
        --row ;
    }

    total_to_read = image_info->total ;
    current_block = 0 ;
    run_ctr = 1 ;
    while (total_to_read > 0)
    {
        if (total_to_read >= MAX_TO_READ)
        {
            total_read = MAX_TO_READ ;
            total_to_read -= MAX_TO_READ ;
        }
        else
        {
            total_read = total_to_read ;
            total_to_read = 0 ;
        }
        bytes_processed = 0 ;
	    /* if data not already read */
        if (!(image_info->compression & LEMPEL_ZIV))
        {
            if (!xdr_opaque(xdrsp,image_info->data,total_read))
            {
                fprintf (stderr,"xdr_opaque died with CCC\n");
                return (0) ;
            }
        }
        ptin = image_info->data ;
	    /* for all 4x4 BTC blocks */
        while ((current_block < total_blocks) && (bytes_processed < MAX_TO_READ))
        {
            if ((current_block % block_width_num) == 0)
            {
                if (current_block != 0)
                {
			/* display 4 rows in frame buffer */
                    PutRow (part,0,image_info->width-1,row,-1);
                    PutRow (part+image_info->width,0,image_info->width-1,row+1,-1);
                    PutRow (part+image_info->width*2,0,image_info->width-1,row+2,-1);
                    PutRow (part+image_info->width*3,0,image_info->width-1,row+3,-1);
                    row -= SIZBLOC ;
                }
                ptbloc = &(part[3*image_info->width+center_x_left]) ;
            }
            ind0 = *ptin++ ;
            ind1 = *ptin++ ;
            pix0 = map.h_map [ind0 ] ;
            pix1 = map.h_map [ind1 ] ;
		/* if 2 colors in 4x4 block */
            if ( ind0 != ind1 )
            {
		register unsigned short *ptc ;
		register unsigned short bitmap ;	/* BTC bitmap */

		run_ctr = 1 ;
                bitmap = *ptin++ ;
                bitmap = (bitmap << 8) | *ptin ;
                ++ptin ;
                    /* scan the bit map and assign the colors */
                ptc = ptbloc ;
                *ptc++ = ( bitmap & 01 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 02 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 04 ) ? pix1 : pix0 ; 
                *ptc = ( bitmap & 010 ) ? pix1 : pix0 ; 
                ptc -= decal ;
                *ptc++ = ( bitmap & 020 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 040 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 0100 ) ? pix1 : pix0 ; 
                *ptc = ( bitmap & 0200 ) ? pix1 : pix0 ; 
                ptc -= decal ;
                *ptc++ = ( bitmap & 0400 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 01000 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 02000 ) ? pix1 : pix0 ; 
                *ptc = ( bitmap & 04000 ) ? pix1 : pix0 ; 
                ptc -= decal ;
                *ptc++ = ( bitmap & 010000 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 020000 ) ? pix1 : pix0 ; 
                *ptc++ = ( bitmap & 040000 ) ? pix1 : pix0 ; 
                *ptc = ( bitmap & 0100000 ) ? pix1 : pix0 ; 
            }
            else			/* expand run-length */
            {
		unsigned short bloc[4] ;
                register unsigned short *ptc ;

                run_ctr = *ptin++ ;
                run_ctr = (run_ctr << 8) | *ptin ;
                ptin++ ;
		if (run_ctr > block_width_num)
		    fprintf (stderr,"bad run length\n") ;
                *(bloc+3) = *(bloc+2) = *(bloc+1) = *bloc = pix0 ;
		ptc = ptbloc ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC)
		    memcpy(ptc,bloc,SIZBLOC*sizeof(short)) ;
		ptc = ptbloc - image_info->width ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC)
		    memcpy(ptc,bloc,SIZBLOC*sizeof(short)) ;
		ptc = ptbloc - image_info->width * 2 ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC)
		    memcpy(ptc,bloc,SIZBLOC*sizeof(short)) ;
		ptc = ptbloc - image_info->width * 3 ;
		for (j = 0 ; j < run_ctr ; j++, ptc += SIZBLOC)
		    memcpy(ptc,bloc,SIZBLOC*sizeof(short)) ;
            }
            bytes_processed += 4 ;
            current_block += run_ctr ;
            ptbloc += (SIZBLOC*run_ctr) ;
        }
    }			/* end for a group of lines */
	/* display last group */
    PutRow (part,0,image_info->width-1,row,-1);
    PutRow (part+image_info->width,0,image_info->width-1,row+1,-1);
    PutRow (part+image_info->width*2,0,image_info->width-1,row+2,-1);
    PutRow (part+image_info->width*3,0,image_info->width-1,row+3,-1);
    for (k = 0 ; k < image_info->width * SIZBLOC ; k++)
	part[k] = (unsigned short) border_color ;
    for (k = center_y_top ; k < image_info->height ; k++)
        PutRow (part,0,image_info->width-1,image_info->height-k-1,-1);
    return (1) ;
}




/* converts 8-bit incoming image to TARGA 16 format and displays */

bool_t 
xdr_qdata (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;

{
    long border_color ;
    unsigned short *ptc ;
    unsigned short part [SCANSIZE] ;	/* decompressed scan lines */
    unsigned char *packptr ;
    int i, j, k ;

    border_color = (long) (((back_red & 0xf8) << 7) |
			   ((back_green & 0xf8) << 2) |
                           (back_blue >> 3)) ;
    SetBorderColor(&border_color) ;

    for (i = 0 ; i < image_info->width ; i++)
	part[i] = (unsigned short) border_color ;
#ifdef DEBUG
    printf ("qdata: left %d bottom %d top %d\n",center_x_left,center_y_bottom,center_y_top) ;
#endif
    for (i = 0 ; i < center_y_bottom ; i++)
        PutRow (part,0,image_info->width-1,image_info->height-i-1,-1);
    ptc = part ;
    packptr = image_info->data ;
	/* get and display image */
    for (i = center_y_bottom ; i < center_y_top ; i ++)
    {
        if (!xdr_opaque(xdrsp,image_info->data,image_info->client_wd))
        {
            fprintf (stderr,"xdr_opaque died\n") ;
            return (0) ;
        }
        ptc += center_x_left ;
        for (k = 0 ; k < image_info->client_wd ; k++)
            *ptc++ = map.h_map[*packptr++] ;
        PutRow (part,0,image_info->width-1,image_info->height-i-1,-1);
        ptc = part ;
        packptr = image_info->data ;
    }
    for (i = 0 ; i < image_info->width ; i++)
	part[i] = (unsigned short) border_color ;
    for (i = center_y_top ; i < image_info->height ; i++)
        PutRow (part,0,image_info->width-1,image_info->height-i-1,-1);
    return(1) ;
}




/* gets incoming 16-bit image and displays it */

bool_t 
xdr_udata (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;

{
    long border_color ;
    unsigned short part [SCANSIZE] ;	/* decompressed scan lines */
    unsigned short *data_ptr ;
    int i, j ;

    border_color = (long) (((back_red & 0xf8) << 7) |
			   ((back_green & 0xf8) << 2) |
                           (back_blue >> 3)) ;
    SetBorderColor(&border_color) ;

    for (i = 0 ; i < image_info->width ; i++)
	part[i] = (unsigned short) border_color ;
#ifdef DEBUG
    fprintf (stderr,"udata: left %d bottom %d top %d\n",center_x_left,center_y_bottom,center_y_top) ;
#endif
	/* fill in bottom border if necessary */
    for (i = 0 ; i < center_y_bottom ; i++)
        PutRow (part,0,image_info->width-1,image_info->height-i-1,-1);
	    /* get and display image */
    for (i = center_y_bottom ; i < center_y_top ; i ++)
    {
#ifdef LATER
        data_ptr = (unsigned short *) image_info->data ;
        for (j = 0 ; j < image_info->client_wd ; j++)
            if (!xdr_short(xdrsp,data_ptr++))
                return(0) ;
#endif
        if (!xdr_opaque(xdrsp,image_info->data,image_info->client_wd*2))
        {
            fprintf (stderr,"xdr_opaque died\n") ;
            return (0) ;
        }
        memcpy((unsigned char*)(part+center_x_left),image_info->data,image_info->client_wd*2) ;
        PutRow (part,0,image_info->width-1,image_info->height-i-1,-1);
    }
    for (i = 0 ; i < image_info->width ; i++)
	part[i] = (unsigned short) border_color ;
    for (i = center_y_top ; i < image_info->height ; i++)
        PutRow (part,0,image_info->width-1,image_info->height-i-1,-1);
    return(1) ;
}
