/* panason.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* init_pana:  initialize optical disk
   com_send:  send string to com1 */


#include <stdio.h>

#define	STX '\002'	/* ascii codes used in optical recorder */
#define ETX '\003'	/* status messages */

FILE *com1_in; FILE *com1_out;

void com_send(char *); int init_pana(void);



/* initialize Panasonic */

int init_pana()
{
    if((com1_in = fopen("com1", "r")) == NULL) { perror("com1"); return(0); }
    if((com1_out = fopen ("com1","w")) == NULL) { perror("com1"); return(0); }

    com_send("ON4:");	/* Put VCR online */
    /* These four are not necessary, but ensure everything will work */
    com_send("AC@");	/* Clear command buffer */
    com_send("TF");	/* Make sure the disk is ready */
    com_send("DR");	/* We want no frame numbers for movie display */
    com_send("VS");	/* Turn video on */
    return(1);
}



/* communicate with Panasonic over RS-232 */

void com_send(string)

char *string;

{
    int status;

    fprintf(com1_out, "%c%s%c\n", STX, string, ETX);
    fflush(com1_out);
    while(fgetc(com1_in) == EOF);
    while((status = fgetc(com1_in)) != EOF) if(status == ETX) return;
}
