/* sony.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <time.h>

/* reads script to control playback of frames on the Sony
   videodisk */

#define SLOW 0
#define FAST 1

/* MODIFY for your installation */
#define BLANK_FRAME 33L

main (argc,argv)

int argc ;
char *argv[] ;

{
    FILE *in ;
    char line[80] ;
    char command[80] ;
    long seconds ;
    long initial ;
    long search_frame = 0L ;
    long playto_frame = 0L ;
    long prev_frame = 0L ;
    char mode[80] ;
    int speed = 1 ;
    int slow_or_fast ;
    int i ;

    void sony_search() ;

    if ((in = fopen (argv[1],"r")) == NULL)
    {
        fprintf (stderr,"no file of that name\n") ;
        exit(0) ;
    }
    while ((fgets(line,80,in)) != NULL)
    {
	if (line[0] == '#')
	    fputs(line,stderr) ;
        else if ((strncmp("blank",line,5)) == 0)
	{
	    sscanf (line,"%s",command) ;
#ifdef DEBUG
	    fprintf (stderr,"%s\n",command) ;
#endif
	    sony_search(BLANK_FRAME) ;
	}
        else if ((strncmp("hold",line,4)) == 0)
	{
	    sscanf (line,"%s %ld",command,&seconds) ;
#ifdef DEBUG
	    fprintf (stderr,"%s %ld\n",command,seconds) ;
#endif
	    initial = time(NULL) ;
	    while ((time(NULL)-initial) < seconds) ;
	}
        else if ((strncmp("search",line,6)) == 0)
	{
	    sscanf (line,"%s %ld",command,&search_frame) ;
#ifdef DEBUG
	    fprintf (stderr,"%s %ld\n",command,search_frame) ;
#endif
	    prev_frame = search_frame ;
	    sony_search(search_frame) ;
	}
        else if ((strncmp("playto",line,6)) == 0)
	{
	    sscanf (line,"%s %d %s %ld",command,&playto_frame,
				       mode,&speed) ;
#ifdef DEBUG
	    fprintf (stderr,"%s %ld %s %d\n",command,playto_frame,mode,speed) ;
#endif
	    if (mode[0] = 'f')
		slow_or_fast = FAST ;
	    else
		slow_or_fast = SLOW ;
	    sony_clear() ;
	    printf ("playing from %ld to %ld at 1/%d speed\n",prev_frame,
							      playto_frame,speed) ;

	    sony_playback(slow_or_fast,speed,playto_frame) ;
	    prev_frame = playto_frame ;
	}
    }
    fclose(in) ;
}
