/* xdrread.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* Part of server RPC library. */

#include <stdio.h>
#include "scrysrv.h"
#include "image.h"


/*  xdr_prelim:		XDR decodes information controlling reading and display
			of incoming image
    xdr_init_ret:	XDR encodes information about initialization of
			videodisk
    xdr_init_req:	XDR decodes requested videodisk initialization
			information and movie log information
    xdr_visout:		XDR encodes information about server display
    xdr_get_lzw:	gets LZW compressed image    */


bool_t 
xdr_prelim (xdrsp,image_info)

XDR *xdrsp ;     /* XDR handle */
struct image_stuff *image_info ;	/* control information */

{
	    /* following two arguments only used on non-PC
	       servers */
    if (!xdr_long(xdrsp,&image_info->current_frame_to_save))
        return (0) ;
    if (!xdr_long(xdrsp,&image_info->total_frames))
        return (0) ;
	    /* compression type */
    if (!xdr_long(xdrsp,&image_info->compression))
        return (0) ;
	    /* total bytes in compressed image (before Lempel-Ziv
	       compression, if that has been performed */
    if (!xdr_long(xdrsp,&image_info->total))
        return (0) ;
    if (!xdr_long(xdrsp,&image_info->client_ht))
        return (0) ;
    if (!xdr_long(xdrsp,&image_info->client_wd))
        return (0) ;
	    /* image color resolution in bytes */
    if (!xdr_long(xdrsp,&image_info->client_im_bytes))
        return (0) ;
    if (image_info->compression & LEMPEL_ZIV)
            /* number of bytes in total frame with addition of
               Lempel-Ziv compression */
        if (!xdr_long(xdrsp,&image_info->total_lz))
            return (0) ;
    if (!xdr_long(xdrsp,&image_info->in_at))	/* starting frame */
        return (0) ;
    if (!xdr_long(xdrsp,&image_info->out_at))	/* ending frame to record */
        return (0) ;			/* image on */
#ifdef DEBUG
printf ("in_at, out_at = %ld %ld\n",image_info->in_at,image_info->out_at) ;
#endif
    return(1) ;
}




/* XDR encodes information about initialization of videodisk */

bool_t 
xdr_init_ret (xdrsp,rec_return)

XDR *xdrsp ;		/* XDR handle */
struct recinfo *rec_return ;

{
	    /* optical disk or not */
    if (!xdr_long(xdrsp,&(rec_return->optflag)))
	return (0) ;
	    /* starting frame requested */
    if (!xdr_long(xdrsp,&(rec_return->start_frame)))
	return (0) ;
	    /* number of frames requested to record */
    if (!xdr_long(xdrsp,&(rec_return->total)))
	return (0) ;
    return(1) ;
}




/* XDR decodes requested videodisk initialization information
   and movie log information */

bool_t 
xdr_init_req (xdrsp,rec_send)

XDR *xdrsp ;		/* XDR handle */
struct recinfo *rec_send ;

{
    long dummy ;

	    /* optical disk or not */
    if (!xdr_long(xdrsp,&(rec_send->optflag)))
	return (0) ;
	    /* actual starting frame */
    if (!xdr_long(xdrsp,&(rec_send->start_frame)))
	return (0) ;
	    /* frames requested */
    if (!xdr_long(xdrsp,&(rec_send->total)))
	return (0) ;
	    /* movie log information */
    if (!xdr_bytes(xdrsp,&(rec_send->username),&dummy,80))
	return (0) ;
    if (!xdr_bytes(xdrsp,&(rec_send->system_name),&dummy,80))
	return (0) ;
    if (!xdr_bytes(xdrsp,&(rec_send->movie_title),&dummy,100))
	return (0) ;
    return(1) ;
}





/* XDR encodes information about server display */

bool_t 
xdr_visout (xdrsp,vis_info)

XDR *xdrsp ;		/* XDR handle */
struct image_stuff *vis_info ;

{
    long height, width ;

	    /* color resolution of server display in bytes */
    if (!xdr_long(xdrsp,&(vis_info->depth)))
	return (0) ;
    height = (long) vis_info->height ;
    if (!xdr_long(xdrsp,&height))
	return (0) ;
    width = (long) vis_info->width ;
    if (!xdr_long(xdrsp,&width))
	return (0) ;
    if (!xdr_long(xdrsp,&(vis_info->recordable)))
	return (0) ;
    return(1) ;
}




/* gets LZW compressed image */

bool_t 
xdr_get_lzw (xdrsp,image_info)

XDR *xdrsp ;			/* XDR handle */
struct image_stuff *image_info ;

{
    if (!xdr_opaque(xdrsp,image_info->data,image_info->total))
    {
        fprintf (stderr,"xdr_opaque died with CCC\n");
        return (0) ;
    }
    return (1) ;
}
