#include <stdio.h>
#include <math.h>

#include <sipp.h>
#include <primitives.h>



main(argc, argv)
    int    argc;
    char **argv;
{
    FILE    *fp ;
    Surf_desc surf;
    int      side;


    if (argc != 2) {
        side = 256;
    } else {
        side = atoi(argv[1]);
    }

    sipp_init();

    lightsource_push(1.0, 1.0, 1.0, 0.9);
    lightsource_push(-1.0, -1.0, 0.5, 0.4);

    surf.ambient = 0.5;
    surf.color.red = 0.8;
    surf.color.grn = 0.5;
    surf.color.blu = 0.2;
    surf.specular = 0.6;
    surf.c3 = 0.2;
    
    object_install(sipp_block(1.0, 2.0, 3.0, &surf, basic_shader)); 

    viewpoint(7.0, 3.0, 5.0,  0.0, 0.0, 0.0,  0.0, 0.0, 1.0,  0.4);

    printf("Rendering, wait...");
    fflush(stdout);

    fp = fopen("block.ppm", "w");
    render_image(side, side, fp);
    printf("Done.\n");
}

