/**
 ** sipp - SImple Polygon Processor
 **
 **  A general 3d graphic package
 **
 **  Copyright Jonas Yngvesson  (jonas-y@isy.liu.se) 1988/89/90/91
 **            Inge Wallin      (ingwa@isy.liu.se)         1990/91
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation; either version 1, or any later version.
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 ** You can receive a copy of the GNU General Public License from the
 ** Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 **/

/**
 ** bozo.c - Bozo shader: color objects a la Bozo the clown.
 **/

#include <math.h>
#include <stdio.h>

#include <sipp.h>
#include <noise.h>
#include <shaders.h>


extern bool noise_ready;

void
bozo_shader(nx, ny, nz, u, v, w, view_vec, lights, bd, color)
    double  nx, ny, nz, u, v, w;
    Vector  view_vec;
    Lightsource *lights;
    Bozo_desc *bd;
    Color *color;
{
    Vector     tmp;
    Surf_desc  surface;
    double     noiseval;
    int        i;

    if (!noise_ready) {
        noise_init();
    }

    tmp.x = u * bd->scale;
    tmp.y = v * bd->scale;
    tmp.z = w * bd->scale;
    noiseval = noise(&tmp);

    i = (noiseval + 1) * bd->no_of_cols / 2.0;
    surface.color    = bd->colors[i];
    surface.ambient  = bd->ambient;
    surface.specular = bd->specular;
    surface.c3       = bd->c3;
    basic_shader(nx, ny, nz, u, v, w, view_vec, lights, &surface, color);
}
