#ifndef swShader_PixelShader_hpp
#define swShader_PixelShader_hpp

#include "CodeGenerator.hpp"

#include "Types.hpp"

namespace swShader
{
	struct Point;
	struct Vector;
	struct Matrix;

	class PixelShader : protected SoftWire::CodeGenerator
	{
	public:
		virtual void execute() = 0;
		virtual void (*executable())() = 0;

		virtual void loadConstants() = 0;

		static void setFloatConstant(int index, const float value[4]);

		static void setFloatConstant(int index, const Point &P);
		static void setFloatConstant(int index, const Vector &V);
		static void setFloatConstant(int index, const Matrix &M);

	protected:
		static float4 c[32];
	};
}

#endif swShader_PixelShader_hpp
