#import "aGroup-inter.h"
#import "aGroup.h"
#import "cm.h"

@implementation cm
- defaultConfig
{
  [self noAngleSetup];
  return self;
}

- resizeGenerator
{
  latticesize.height = frame.size.height;
  latticesize.width = frame.size.width;
  upx = latticesize.width / 2;
  upy = latticesize.height ;
  overx = latticesize.width;
  gravy = 0.0;
  gravx = overx/2;
  return self;
}

- clip: (NXCoord) x: (NXCoord) y 
{ 
  PSmoveto(x,y);
  PSrlineto(upx,upy);
  PSrlineto(upx,-upy);
  PSclosepath();
  PSclip();
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  PSgsave();
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave();
  reflect(0.0);
  [self clip:0.0:0.0];
  [imgrep drawAt: &pt];
  PSgrestore();
  return self;
}
@end
