#import "p6m.h"

@implementation p6m
- resizeGenerator
{
  [super resizeGenerator];
  // change upy to be correct
  upy = 3 * bounds.size.height;
  return self;
}
- clip: (NXCoord) x: (NXCoord) y 
{ 
  PSnewpath();
  PSmoveto(x,y);
  PSrlineto(bounds.size.width,0);
  PSrlineto(0,bounds.size.height);
  PSclosepath();
  PSclip();
  return self;
}
- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  int i;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  for(i=0;i<6;i++){
    PSgsave();
    PSrotate(60*i);
    PSgsave();
    [self clip:0.0:0.0];
    [imgrep drawAt: &pt];
    PSgrestore();
    reflect(30);
    [self clip:0.0:0.0];
    [imgrep drawAt: &pt];
    PSgrestore();
  }
  return self;
}

- sizeKludge: (float *) x : (float *) y
{
  float hyp;

  *x = [self equi: 2.0 * *y];
  return self;
}
@end
