#import "aGroup-inter.h"
#import "aGroup.h"
#import "pmm.h"

@implementation pmm

- defaultConfig
{
  [self noAngleSetup];
  return self;
}

- clip: (float) x : (float) y
{
  PSmoveto(x,y);
  PSrectclip(0,0,frame.size.width,frame.size.height);
}

- resizeGenerator
{
  latticesize.height = 2.0* bounds.size.height;
  latticesize.width = 2.0 * bounds.size.width;
  upx = 0;
  upy = latticesize.height;
  overx = latticesize.width;
  gravy = upy/2;
  gravx = (upx+overx)/2;
  return self;
}

- makeLatticeUnitAt: (NXPoint *) point fromImage: srcimg 
{
  id imgrep;
  NXPoint pt;
  
  pt.x = - point->x ;
  pt.y = - point->y ;
  imgrep = [srcimg bestRepresentation];
  PSgsave(); // lower left
  [self clip:0.0:0.0];[imgrep drawAt: &pt];
  PSgrestore();
  PSgsave(); // upper left
  reflect(0.0);
  PStranslate(0,-2*bounds.size.height);
  [self clip:0.0:0.0]; [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave(); // lower right
  reflect(90);
  PStranslate(2*bounds.size.width,0);
  [self clip:0.0:0.0]; [imgrep drawAt: &pt];
  PSgrestore();
  PSgsave();// upper right
  PSrotate(180);
  PStranslate(2*bounds.size.width,-2*bounds.size.height);
  [self clip:0.0:0.0]; [imgrep drawAt: &pt];
  PSgrestore();
  return self;
}

- (BOOL) isRigidLattice { return YES; };
@end
