#include <math.h>
#include <stdio.h>
#include "art.h"
#include "objs.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp;
extern mats	*mstackp;
extern float	tolerance;

extern hlist	*fhlist;

extern matrix	trans;

extern symbol	*findsym(), *insertsym();

extern int	lookatdone;

/*
 * geometry file list
 */
static symbol	*geoms = (symbol *)NULL;
static symbol	*colours = (symbol *)NULL;
static symbol	*normals = (symbol *)NULL;

/*
 * ray details
 */
static vector	dir, org;
static float	orgu, orgv, diru, dirv;

/*
 * ray box dimensions
 */
static float	minu, maxu, minv, maxv;

/*
 * normals for the polygons
 */
static vector	*fnorms;

/*
 * polygon object
 */
static object	*obj;

/*
 * hitlist ptr for this object
 */
static hlist	*hitlist;

/*
 * options
 */
static int	backfacing;

/*
 * readgeometry
 *
 *	reads in and sets up a polygon model from a geometry file, care
 * is taken to make sure the same file is not read in twice.
 */
readgeometry(name, geom, pnorms, vnorms)
	char		*name;
	geometry	**geom;
	vector		**pnorms, **vnorms;
{
        float		minx, maxx, miny, maxy, minz, maxz;
	float		*xs, *ys, *zs, midminv;
	int		nverts, connections, npnts;
	int		i, j, numedges, phong, delcount;
	int		*ntris, *npolys, cvertno, bas, start, next;
	vertno		*vertnums, *pntno;
	FILE		*pfile;
	vector		v, v1, v2, norm, *norms, *nrms;
	facet		*face, **polys[DIMS], *faces;
	unsigned char	*axis;
	char		buf[BUFSIZ];
	symbol		*sym;
	geometry	*gm;

	if ((pfile = fopen(name, "r")) == NULL) {
		sprintf(buf, "art: cannot open offfile %s.\n", name);
		fatal(buf);
	}

	if (fscanf(pfile, "%d %d %d\n", &nverts, &connections, &numedges) != 3) {
		sprintf(buf, "art: can't find header info in offfile %s.\n", name);
		fatal(buf);
	}

	xs = (float *)smalloc(sizeof(float) * nverts);
	ys = (float *)smalloc(sizeof(float) * nverts);
	zs = (float *)smalloc(sizeof(float) * nverts);

	fscanf(pfile, "%f %f %f\n", &v1.x, &v1.y, &v1.z);

	minx = maxx = v1.x;
	miny = maxy = v1.y;
	minz = maxz = v1.z;
	xs[0] = v1.x; ys[0] = v1.y; zs[0] = v1.z;

	for (i = 1; i != nverts; i++) {
		fscanf(pfile, "%f %f %f\n", &v1.x, &v1.y, &v1.z);
		minmax(minx, maxx, v1.x);
		minmax(miny, maxy, v1.y);
		minmax(minz, maxz, v1.z);
		xs[i] = v1.x; ys[i] = v1.y; zs[i] = v1.z;
	}

	pushmatrix();

		calctransforms(mstackp);
		multmatrix(mstackp->obj2ray);

		delcount = cvertno = 0;
		for (i = 0; i != connections; i++) {
			fscanf(pfile, "%d", &npnts);
			fscanf(pfile, "%d", &start);
			start -= 1;

			move(xs[start], ys[start], zs[start]);
			
			for (j = 1; j != npnts; j++) {
				fscanf(pfile, "%d", &next);
				next -= 1;
				draw(xs[next], ys[next], zs[next]);
			}

			draw(xs[start], ys[start], zs[start]);
		}

	popmatrix();

	free(xs);
	free(ys);
	free(zs);

	fclose(pfile);
}

/*
 * readcolours
 *
 *	read in the colour information for a geometry file
 */
readcolours(name, col, colindxs)
	char		*name;
	vector		**col;
	unsigned short	**colindxs;
{
	FILE		*cfile;
	int		numcols, numindexes, i;
	vector		*cl;
	unsigned short	*inds;
	char		buf[BUFSIZ];
	symbol		*sym;

	if ((cfile = fopen(name, "r")) == NULL) {
		sprintf(buf, "art: cannot open colourfile %s.\n", name);
		fatal(buf);
	}

	fclose(cfile);
}

/* 
 * readnormals
 *
 *	read in the polygon normal information for a geometry file
 */
readnormals(name, norms)
	char	*name;
	vector	**norms;
{
	FILE		*nfile;
	int		nnorms, i;
	char		buf[BUFSIZ];
	symbol		*sym;
	vector		*nrms;

	if ((nfile = fopen(name, "r")) == NULL) {
		sprintf(buf, "art: cannot open normalfile %s.\n", name);
		fatal(buf);
	}

	fclose(nfile);
}

/* 
 * readvnormals
 *
 *	read in the vertex normal information for a geometry file
 */
readvnormals(name, norms, ntable)
	char	*name;
	vector	**norms;
	vertno	***ntable;
{
	FILE		*nfile;
	int		nnorms, npolys, nedges, i, j, npoints, cvertno;
	char		buf[BUFSIZ];
	symbol		*sym;
	vector		*nrms;
	vertno		**ntbl, *verts, *pntno;

	if ((nfile = fopen(name, "r")) == NULL) {
		sprintf(buf, "art: cannot open vnormalfile %s.\n", name);
		fatal(buf);
	}

	if (fscanf(nfile, "%d %d %d ", &nnorms, &npolys, &nedges) != 3) {
		sprintf(buf, "art: bad header in vnormalfile %s.\n", name);
		fatal(buf);
	}

	fclose(nfile);
}

/*
 * geometryinit
 *
 *	sets up a geometry object, this is always a geometry file.
 */
void
geometryinit(o, d)
	object	*o;
	details	*d;
{
	details		*ld;
	float		radius;
	vector		*cols;
	unsigned short	*colindexes;
	vector		c1, c2, cent, *pnorms1, *pnorms2, *vnorms1, *vnorms2;
	vertno		**vnormtab;
	geometry	*geom;

	cols = (vector *)NULL;
	colindexes = (unsigned short *)NULL;

	vnorms1 = vnorms2 = (vector *)NULL;
	pnorms1 = pnorms2 = (vector *)NULL;
	vnormtab = (vertno **)NULL;

	if (!lookatdone)
		deflookat();

	while (d != (details *)NULL) {
		switch (d->type) {
		case OFFFILE:
			readgeometry(d->u.s);
			break;
		case COLOURFILE:
			readcolours(d->u.s);
			break;
		case NORMALFILE:
			readnormals(d->u.s);
			break;
		case VNORMALFILE:
			readvnormals(d->u.s);
			break;
		default:
			warning("art: illegal field in geometry ignored.\n");
		}
		ld = d;
		d = d->nxt;
		free(ld);
	}
}
