#include <stdio.h>
#include <math.h>
#include "art.h"
#include "macro.h"
#include "gram.h"

extern attr	*astackp, astack[];
extern mats	*mstackp, mstack[];

extern matrix	trans;
extern vector	org;
extern int	linecount;

/*
 * utility routines for adjusting transformations and other
 * object attributes.
 */

/*
 * art_rotate
 *
 * 	adjust the transformation matrix for a rotate
 */
art_rotate(ang, axis)
	float	ang;
	char	axis;
{
	matrix	mat, tmp;
	float	sinval, cosval;

	mident4(mat);
	sinval = sin(-ang * M_PI / 180.0);
	cosval = cos(-ang * M_PI / 180.0);

	switch (axis) {
	case 'x':
		mat[1][1] = cosval;
		mat[1][2] = -sinval;
		mat[2][2] = cosval;
		mat[2][1] = sinval;
		break;
	case 'y':
		mat[0][0] = cosval;
		mat[0][2] = sinval;
		mat[2][0] = -sinval;
		mat[2][2] = cosval;
		break;
	case 'z':
		mat[0][0] = cosval;
		mat[0][1] = -sinval;
		mat[1][0] = sinval;
		mat[1][1] = cosval;
		break;
	default:
		fatal("art: bad axis name in rotate.\n");
	}

	mcpy4(tmp, mstackp->vm);
	mmult4(mstackp->vm, tmp, mat);

	mstackp->vmused = TRUE;
}

/*
 * art_translate
 *
 *	translate
 */
art_translate(x, y, z)
	float	x, y, z;
{
	matrix	mat, tmp;

	mident4(mat);

	mat[3][0] = x;
	mat[3][1] = y;
	mat[3][2] = z;

	mcpy4(tmp, mstackp->vm);
	mmult4(mstackp->vm, tmp, mat);

	mstackp->vmused = TRUE;
}

/*
 * art_scale
 *
 *	scale routine
 */
art_scale(x, y, z)
	float	x, y, z;
{
	matrix	mat, tmp;

	mident4(mat);

	mat[0][0] *= x;
	mat[1][1] *= y;
	mat[2][2] *= z;

	mcpy4(tmp, mstackp->vm);
	mmult4(mstackp->vm, tmp, mat);

	mstackp->vmused = TRUE;
}

/*
 * calctransforms
 *
 *	calculate the current ray2obj and obj2ray transformation
 * matrices.
 */
calctransforms(msp)
	mats	*msp;
{
	matrix		tmp, tmp1, tmp2;
	mats		*mp;

	if (msp->vmused) {
		if (msp != mstack) {
			mp = msp;
			mcpy4(tmp1, mp->vm);
			while (mp != mstack) {
				mmult4(tmp2, tmp1, (mp - 1)->vm, tmp1);
				mcpy4(tmp1, tmp2);
				mp--;
			}
		} else
			mcpy4(tmp1, msp->vm);
		mcpy4(msp->obj2ray, tmp1);
	} else
		return;

	msp->vmused = FALSE;
}
