
#include "gpp.h"
#include "vopl.h"

extern	float	strlength();

/*
 * drawlegend
 *
 *	Draw a legend for gpp
 */
void
drawlegend()
{
	float	ydiff, x, y;
	char	buf[80];
	int	i = 0;
	graph	*p;

	ydiff = 2 * TEXTHEIGHT;
	y = YMAX;
	x =  XMAX + 3 * TEXTWIDTH;

	clipping(0);
	centertext(1);

	textsize(TEXTWIDTH * 1.2, TEXTHEIGHT * 1.2);

	/*
 	 * First draw all the marker symbols
	 */
	for (i = 0; i < ngraphs; i++) {
		color((i % 7) + 1);
		move2(x, y);
		drawchar('a' + i);
		y -= ydiff;
	}

	/*
	 * Now fill in the legends
	 */

	if (fontname[0])
		font(fontname);
	else
		font("futura.l");

	textsize(TEXTWIDTH * 1.2, TEXTHEIGHT * 1.2);

	y = YMAX;
	i = 0;
 
	for (p = gp; p != (graph *)NULL; p = p->nxt) {
		color((i++ % 7) + 1);
		if (strlen(p->legend) != 0) {
			buf[0] = buf[1] = buf[3] = ' ';
			buf[2] = '-';
			buf[4] = '\0';
			strcat(buf, p->legend);
			move2(x + strlength(buf) / 2, y);
			drawstr(buf);
			y -= ydiff;
		}
	}

	centertext(0);
	clipping(1);
}
